% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{footdata}
\alias{footdata}
\title{footdata}
\format{
footdata data refers to a marketing research study from 2018 concerning
the experience of watching a football match in the stadium of a top Spanish football club.
For confidentiality reasons,
the complete details of the survey-based study will not be provided. Only the description
of the variables is given. The data consist of a total of 20 variables, measured for
362 spectators. The 20 variables are divided into two groups. One group is
formed of 15 indicator variables for the structural model, and the other group
is formed of 5 categorical variables. Each block of indicator refers to a specific construct.


Latent variable description
\describe{
     \item{\code{QUA}: }{Spectators’ perception of service performance, based on evaluations of service dimensions}
     \item{\code{IMA}: }{Spectators’ perception of the attributes, players, management and condition of the club}
     \item{\code{SAT}: }{Spectators’ evaluation of the perceived benefits of attending a match}
     \item{\code{LOY}: }{Spectators’ deeply held commitment to repeat and recommend assisting a match}
}

Manifest variables description
\describe{
\item{\code{QUA1}: }{Tickets (availability, information, and staff attitudes)}
\item{\code{QUA2}: }{Accessibility (accessibility, signposting, queue safety, and admission organization)}
\item{\code{QUA3}: }{Facilities (shops, restrooms, seating, restaurants)}
\item{\code{QUA4}: }{Stadium (loudspeakers, appearance, staff competence, cleanliness, Security/safety)}
\item{\code{IMA1}: }{It is a great club}
\item{\code{IMA2}: }{It has a good team}
\item{\code{IMA3}: }{It is an ambitious club}
\item{\code{IMA4}: }{It is a heroic club}
\item{\code{SAT1}: }{The stadium experience was satisfactory}
\item{\code{SAT2}: }{The time spent at the stadium was worth it}
\item{\code{SAT3}: }{The money spent at the stadium was worth it}
\item{\code{SAT4}: }{The experience met all my expectations}
\item{\code{SAT5}: }{Overall satisfaction}
\item{\code{LOY1}: }{I would recommend the experience at this stadium}
\item{\code{LOY2}: }{I intend to repeat the experience at this stadium}
}

Categorical Variables description
\describe{
\item{\code{gender}: }{Gender of the spectators, a factor with levels: \code{FEMALE} and \code{MALE}}
\item{\code{age}: }{Age of the spectators, a factor with levels \code{<=30}, \code{31-45}, and \code{>=46}}
\item{\code{tourist}: }{Whether the spectator was a tourist or not, a factor with levels: \code{YES} or \code{NO}}
\item{\code{companion}: }{Who Accompanying the spectator, a factor with levels: \code{FRIENDS}, \code{FAMILY}, and \code{OTHERS}}
\item{\code{Involvement}: }{Degree of involvement, a factor with levels: \code{FAN}, \code{MEMBER}, and \code{OTHERS}}
}
}
\source{
Universitat Autonoma of Barcelona .
   Business departament, Universitat Autonoma de Barcelona.
}
\usage{
footdata
}
\description{
footdata
}
\references{
Lamberti, G., Rialp, J., and Simon, A. (2021). Antecedents of satisfaction and
loyalty in different spectator tribes in a football context.
\emph{International Journal of Sports Marketing and Sponsorship},
doi: 10.1108/IJSMS-12-2020-0210;
}
\keyword{datasets}
