% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gensvm.grid.R
\name{gensvm.load.tiny.grid}
\alias{gensvm.load.tiny.grid}
\title{Load a tiny parameter grid for the GenSVM grid search}
\usage{
gensvm.load.tiny.grid()
}
\description{
This function returns a parameter grid to use in the GenSVM 
grid search. This grid was obtained by analyzing the experiments done for 
the GenSVM paper and selecting the configurations that achieve accuracy 
within the 95th percentile on over 90% of the datasets. It is a good start 
for a parameter search with a reasonably high chance of achieving good 
performance on most datasets.

Note that this grid is only tested to work well in combination with the 
linear kernel.
}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{https://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{gensvm.grid}}, \code{\link{gensvm.load.small.grid}}, 
\code{\link{gensvm.load.full.grid}}.
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
