% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_intermediate_region.R
\name{read_intermediate_region}
\alias{read_intermediate_region}
\title{Download spatial data of Brazil's Intermediate Geographic Areas}
\usage{
read_intermediate_region(
  code_intermediate = "all",
  year = 2019,
  simplified = TRUE,
  showProgress = TRUE,
  cache = TRUE
)
}
\arguments{
\item{code_intermediate}{4-digit code of an intermediate region. If the
two-digit code or a two-letter uppercase abbreviation of a state is
passed, (e.g. 33 or "RJ") the function will load all intermediate
regions of that state. If \code{code_intermediate="all"} (Default), the
function downloads all intermediate regions of the country.}

\item{year}{Numeric. Year of the data in YYYY format. Defaults to \code{2019}.}

\item{simplified}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function
should return the data set with 'original' spatial resolution or a data set
with 'simplified' geometry. Defaults to \code{TRUE}. For spatial analysis and
statistics users should set \code{simplified = FALSE}. Borders have been
simplified by removing vertices of borders using \verb{st_simplify\{sf\}} preserving
topology with a \code{dTolerance} of 100.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar.}

\item{cache}{Logical. Whether the function should read the data cached
locally, which is faster. Defaults to \code{cache = TRUE}. By default,
\code{geobr} stores data files in a temporary directory that exists only
within each R session. If \code{cache = FALSE}, the function will download
the data again and overwrite the local file.}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
The intermediate Geographic Areas are part of the geographic division of
Brazil created in 2017 by IBGE. These regions were created to replace the
"Meso Regions" division. Data at scale 1:250,000, using Geodetic reference
system "SIRGAS2000" and CRS(4674)
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read an specific intermediate region
  im <- read_intermediate_region(code_intermediate=1202)

# Read intermediate regions of a state
  im <- read_intermediate_region(code_intermediate=12)
  im <- read_intermediate_region(code_intermediate="AM")

# Read all intermediate regions of the country
  im <- read_intermediate_region()
  im <- read_intermediate_region(code_intermediate="all")
\dontshow{\}) # examplesIf}
}
\seealso{
Other area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_capitals}()},
\code{\link{read_comparable_areas}()},
\code{\link{read_country}()},
\code{\link{read_disaster_risk_area}()},
\code{\link{read_health_facilities}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_indigenous_land}()},
\code{\link{read_meso_region}()},
\code{\link{read_metro_area}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipal_seat}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_pop_arrangements}()},
\code{\link{read_region}()},
\code{\link{read_schools}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_urban_area}()},
\code{\link{read_urban_concentrations}()},
\code{\link{read_weighting_area}()}
}
\concept{area functions}
