% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_obs_dens.R
\name{get_obs_dens}
\alias{get_obs_dens}
\title{Generate observed densities}
\usage{
get_obs_dens(hfr, dep_var, indep_var, ngrid = 100, window)
}
\arguments{
\item{hfr}{hyperframe}

\item{dep_var}{The name of the dependent variable.
Since we need to obtain the observed density of treatment events,
`dep_var` should be the name of the treatment variable.}

\item{indep_var}{vector of names of independent variables (covariates)}

\item{ngrid}{the number of grid cells that is used to generate observed densities.
By default = 100. Notice that as you increase `ngrid`, the process gets computationally demanding.}

\item{window}{owin object}
}
\value{
list of the following:
     * `indep_var`: independent variables
     * `coef`: coefficients
     * `intens_grid_cells`: im object of observed densities for each time period
     * `estimated_counts`: the number of events that is estimated by the poisson point process model for each time period
     * `sum_log_intens`: the sum of log intensities for each time period
     * `actual_counts`: the number of events (actual counts)
}
\description{
`get_obs_dens()` takes a hyperframe and returns observed densities.
The output is used as propensity scores.
}
\details{
`get_obs_dens()` assumes the poisson point process model and
calculates observed densities for each time period. It depends on `spatstat.model::mppm()`.
Users should note that the coefficients in the output are not directly interpretable,
since they are the coefficients inside the exponential of the poisson model.
}
