% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{get_geometry}
\alias{get_geometry}
\title{Get geometry}
\usage{
get_geometry(layer)
}
\arguments{
\item{layer}{A \code{sf} object.}
}
\value{
A string.
}
\description{
Get the geometry of a layer, as it is interpreted to define a \code{geolevel}
object.
}
\details{
It will only be valid if one of the three geometries is interpreted: \emph{point},
\emph{line} or \emph{polygon}.
}
\examples{

layer_us_county <- get_level_layer(gd_us, "county")

geometry <- get_geometry(layer_us_county)

}
\seealso{
Other geolevel definition functions: 
\code{\link{add_geometry}()},
\code{\link{check_key}()},
\code{\link{complete_point_geometry}()},
\code{\link{coordinates_to_geometry}()},
\code{\link{geolevel}()},
\code{\link{get_empty_geometry_instances}()}
}
\concept{geolevel definition functions}
