% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodimension.R
\name{transform_crs}
\alias{transform_crs}
\alias{transform_crs.geodimension}
\title{Transform CRS}
\usage{
transform_crs(gd, crs = NULL)

\method{transform_crs}{geodimension}(gd, crs = NULL)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{crs}{A coordinate reference system: integer with the EPSG code, or
character with proj4string.}
}
\value{
A \code{geodimension}.
}
\description{
Transform the CRS of all the layers included in the dimension to the one
indicated.
}
\examples{

layer_us_place <- gd_us |>
  get_level_layer("place")

layer_us_county <-
  dplyr::inner_join(
    get_level_data_geo(gd_us, "county"),
    get_level_layer(gd_us, "county"),
    by = c("geoid", "statefp", "name", "type")
  ) |>
  sf::st_as_sf()

place <-
  geolevel(name = "place",
           layer = layer_us_place,
           attributes = c("statefp", "county_geoid", "name", "type"),
           key = "geoid")

county <-
  geolevel(
    name = "county",
    layer = layer_us_county,
    attributes = c("statefp", "name", "type"),
    key = "geoid"
  ) |>
  add_geometry(coordinates_to_geometry(layer_us_county,
                                       lon_lat = c("intptlon", "intptlat")))

gd_us <-
  geodimension(name = "gd_us",
               level = place) |>
  add_level(level = county) |>
  transform_crs(crs = 3857)

}
\seealso{
\code{\link{geolevel}}, \code{\link{relate_levels}}, \code{\link{get_level_layer}}

Other geodimension definition functions: 
\code{\link{add_level}()},
\code{\link{geodimension}()},
\code{\link{set_level_data}()}
}
\concept{geodimension definition functions}
