% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geo_peru.R
\name{get_geo_peru}
\alias{get_geo_peru}
\title{Download spatial data of Peru}
\usage{
get_geo_peru(
  geography = "all",
  level = "all",
  simplified = TRUE,
  showProgress = TRUE
)
}
\arguments{
\item{geography}{A character or a vector with the name of geographical region.
An exception is "all" to request all Peru data.}

\item{level}{A character: "all" for national level data, "dep" for department
level data, and "prov" for provincial level data.}

\item{simplified}{A logical TRUE or FALSE, to select data with all districts or
a polygon simplified to a higher level.}

\item{showProgress}{Logical TRUE or FALSE to display a progress bar during download.}
}
\value{
An \verb{"sf" "data.frame"} object containing the spatial data of Peru.
}
\description{
Downloads spatial data of Peru using Geodetic reference system "WGRS84" and CRS(4326).
}
\examples{
\donttest{
# Read specific province
anta <- get_geo_peru(geography = "ANTA",
                     level = "prov",
                     simplified = TRUE)

# Read more than one province
df <- get_geo_peru(geography = c("CALCA"),
                   level = "prov",
                   simplified = FALSE)

# Read department level data
cusco <- get_geo_peru(geography = "cusco",
                      level = "dep",
                      simplified = TRUE)
}
}
