% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementSets.R
\docType{data}
\name{PGE}
\alias{PGE}
\alias{IPGE}
\alias{PPGE}
\title{Platinum-group elements -- PGE}
\format{
character vector with 6 elements.

character vector with 3 elements.

character vector with 3 elements.
}
\usage{
PGE

IPGE

PPGE
}
\description{
Ru-Pd and Os-Pt: in chemistry, this group is referred to as the platinum
metals. Since the 1960 geologists are using the term "platinum-group
elements" (PGE) \insertCite{Marshall1999,Connelly2005}{georefdatar}. In
geochemistry, this group is further divided into two subgroups: Ir-PGE and
Pd-PGE \insertCite{Marshall1999}{georefdatar} with Au often added to the
latter \insertCite{Rollinson1993}{georefdatar}.\cr
\cr
\itemize{
\item PGE   Platinum-group elements -- e.g.
\insertCite{Marshall1999}{georefdatar}.
\item IPGE, PPGE Ir-PGE and Pd-PGE --
\insertCite{Rollinson1993,Marshall1999}{georefdatar};
}
}
\section{Functions}{
\itemize{
\item \code{IPGE}: Ir-PGE subgroup

\item \code{PPGE}: Pd-PGE subgroup

}}
\examples{
# get information from the periodic table of elements
subset(pte, Symbol \%in\% PGE)

}
\references{
\insertRef{Rollinson1993}{georefdatar}

\insertRef{Marshall1999}{georefdatar}

\insertRef{Connelly2005}{georefdatar}
}
\keyword{datasets}
