% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Minerals.R
\name{minSearch}
\alias{minSearch}
\title{Find minerals by their names or symbols}
\usage{
minSearch(pattern, ignore.case = TRUE)
}
\arguments{
\item{pattern}{regular expression for the mineral to search}

\item{ignore.case}{switch case insensitivity on (default) or off}
}
\value{
data.frame of \link[=mins]{minerals} where the given pattern matches.
}
\description{
Searches for \link[=mins]{minerals} by their names and symbols using a
\link[base:regex]{regular expression}. By default cases are ignored.
}
\examples{
minSearch('alm')
minSearch('Pyh$', ignore.case = FALSE)

}
\seealso{
\link[=mins]{List of minerals}, \code{\link[=minsForChemistry]{minsForChemistry()}}
}
