% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{imputed}
\alias{imputed}
\title{Extracting imputed datasets from gerbil objects}
\usage{
imputed(gerb, imp = 1)
}
\arguments{
\item{gerb}{A \code{gerbil} object containing the imputed data.}

\item{imp}{The imputed datasets which are to be returned (defaults to \code{imp = 1}).  Letting \code{m} indicate the number of imputed datasets contained in \code{gerb}, \code{imp} should be a subset of \code{1:m}.
If \code{imp} is a scalar, a single imputed dataset is returned.  If \code{imp} is a vector, then the individual datasets are stacked on top of each other and returned.}
}
\value{
\code{imputed()} returns a data frame or matrix. If \code{imp} has multiple elements, columns are added to indicate the imputation number and the case ID.
}
\description{
Using a \code{gerbil} object as an input, this function returns imputed datasets.
}
\details{
The function either return a single imputed dataset (if \code{imp} is a scalar) or a tall dataset if (if \code{imp} is a vector) with the individual datsets stacked on top of each other.
}
\examples{
\donttest{
#Load the India Human Development Survey-II dataset
data(ihd_mcar)

# Create a gerbil object
imps.gerbil <- gerbil(ihd_mcar, m = 5, ords = "education_level", semi = "farm_labour_days", 
       bincat = "job_field", n.cores = 1)

# Return a single imputed datasets
imp.gerb <- imputed(imps.gerbil, imp = 2)

# Return multiple (stacked) datasets
imp.gerb <- imputed(imps.gerbil, imp = 1:5)
}

}
