% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets.R
\name{set_secret}
\alias{set_secret}
\alias{get_secret}
\title{Set or get secrets from the keyring}
\usage{
set_secret(name, secret = NULL)

get_secret(name)
}
\arguments{
\item{name}{Name of the secret to set or get as a character (e.g.
\code{"nl_api_key"}).}

\item{secret}{Optionally a character string with the secret, alternatively
the system will prompt the user.}
}
\value{
\code{set_secret()} returns \code{TRUE} when a secret has successfully been
set. \code{get_secret()} returns the secret as a character string.
}
\description{
Some services require credentials to access data. This function uses
keyring to safely store those credentials on your computer.
}
\details{
When working with a cluster it might be advantageous to use a specific
keyring, this can be done by setting the \code{keyring_backend} option in R.

The package uses the option \code{getRad.key_prefix} as a prefix to all keys
stored. If you want to use multiple keys for the same api you can manipulate
this option.
}
