% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{gfiUltra}
\alias{gfiUltra}
\title{Generalized fiducial inference for ultrahigh-dimensional regression}
\usage{
gfiUltra(formula, data, nsims = 1000L, verbose = FALSE, gamma = 1, ...)
}
\arguments{
\item{formula}{a formula describing the model}

\item{data}{dataframe in which to search the variables of the model}

\item{nsims}{number of fiducial simulations}

\item{verbose}{whether to print the messages generated by the screening
procedure}

\item{gamma}{tuning parameter; for expert usage only}

\item{...}{named arguments passed to \code{\link[SIS:SIS]{SIS}}, such as
\code{penalty = "lasso"}}
}
\value{
A list with two elements: the fiducial simulations in a matrix
  (\code{fidSims}) and a vector giving the probabilities of the selected
  models (\code{models}).
}
\description{
Generates the fiducial simulations of the parameters of
  a "large p - small n" regression model and returns the selected models
  with their probability.
}
\examples{
# data ####
set.seed(666L)
n <- 300L
p <- 1000L
X <- matrix(rnorm(n * p), nrow = n, ncol = p)
colnames(X) <- paste0("x", 1L:p)
beta <- c(4, 5, 6, 7, 8)
y <- X[, 1L:5L] \%*\% beta + rnorm(n, sd = 0.9)
dat <- cbind(y, as.data.frame(X))
# fiducial simulations ####
gfi <- gfiUltra(y ~ ., data = dat, nsims = 10000L)
# selected models
gfi$models
# fiducial confidence intervals
gfiConfInt(gfi)
# fiducial estimates
gfiEstimates(gfi)
}
\references{
Randy C. S. Lai, Jan Hannig & Thomas C. M. Lee.
  \emph{Generalized Fiducial Inference for Ultrahigh-Dimensional Regression}.
  Journal of the American Statistical Association,
  Volume 110, 2015 - Issue 510, 760-772.
  <doi:10.1080/01621459.2014.931237>
}
