% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg1d.R
\name{gg1d}
\alias{gg1d}
\title{AutoPlot an entire data.frame}
\usage{
gg1d(
  data,
  col_id = NULL,
  col_sort = NULL,
  order_matches_sort = TRUE,
  maxlevels = 6,
  verbose = 2,
  drop_unused_id_levels = FALSE,
  interactive = TRUE,
  return = c("plot", "column_info", "data"),
  palettes = NULL,
  sort_type = c("frequency", "alphabetical"),
  desc = TRUE,
  limit_plots = TRUE,
  max_plottable_cols = 15,
  cols_to_plot = NULL,
  tooltip_column_suffix = "_tooltip",
  ignore_column_regex = "_ignore$",
  convert_binary_numeric_to_factor = TRUE,
  options = gg1d_options(show_legend = !interactive)
)
}
\arguments{
\item{data}{data.frame to autoplot (data.frame)}

\item{col_id}{name of column to use as an identifier. If null, artificial IDs will be created based on row-number.}

\item{col_sort}{name of columns to sort on. To do a hierarchical sort, supply a vector of column names in the order they should be sorted (character).}

\item{order_matches_sort}{should the column plots be stacked top-to-bottom in the order they appear in \code{col_sort} (flag)}

\item{maxlevels}{for categorical variables, what is the maximum number of distinct values to allow (too many will make it hard to find a palette that suits). (number)}

\item{verbose}{Numeric value indicating the verbosity level:
\itemize{
\item \strong{2}: Highly verbose, all messages.
\item \strong{1}: Key messages only.
\item \strong{0}: Silent, no messages.
}}

\item{drop_unused_id_levels}{if col_id is a factor with unused levels, should these be dropped or included in visualisation}

\item{interactive}{produce interactive ggiraph visualiastion (flag)}

\item{return}{a string describing what this function should return. Options include:
\itemize{
\item \strong{plot}: Return the gg1d visualisation (default)
\item \strong{colum_info}: Return a data.frame describing the columns the dataset.
\item \strong{data}: Return the processed dataset used for plotting.
}}

\item{palettes}{A list of named vectors. List names correspond to \strong{data} column names (categorical only). Vector names to levels of columns. Vector values are colours, the vector names are used to map values in data to a colour.}

\item{sort_type}{controls how categorical variables are sorted.
Numerical variables are always sorted in numerical order irrespective of the value given here.
Options are \code{alphabetical} or \code{frequency}}

\item{desc}{sort in descending order (flag)}

\item{limit_plots}{throw an error when there are > \code{max_plottable_cols} in dataset (flag)}

\item{max_plottable_cols}{maximum number of columns that can be plotted (default: 15) (number)}

\item{cols_to_plot}{names of columns in \strong{data} that should be plotted. By default plots all valid columns (character)}

\item{tooltip_column_suffix}{the suffix added to a column name that indicates column should be used as a tooltip (string)}

\item{ignore_column_regex}{a regex string that, if matches a column name,  will cause that  column to be exclude from plotting (string)  (default: "_ignore$")}

\item{convert_binary_numeric_to_factor}{If a numeric column conatins only values 0, 1, & NA, then automatically convert to a factor.}

\item{options}{a list of additional visual parameters created by calling \code{\link[=gg1d_options]{gg1d_options()}}. See \code{\link{gg1d_options}} for details.}
}
\value{
ggiraph interactive visualisation
}
\description{
Visualize all columns in a data frame with gg1d's vertically aligned plots
and automatic plot selection based on variable type.
Plots are fully interactive, and custom tooltips can be added.
}
\examples{
path_gg1d <- system.file("example.csv", package = "gg1d")
df <- read.csv(path_gg1d, header = TRUE, na.strings = "")

# Create Basic Plot
gg1d(df, col_id = "ID", col_sort = "Glasses")

# Configure plot gg1d_options()
gg1d(
  lazy_birdwatcher,
  col_sort = "Magpies",
  palettes = list(
    Birdwatcher = c(Robert = "#E69F00", Catherine = "#999999"),
    Day = c(Weekday = "#999999", Weekend = "#009E73")
  ),
  options = gg1d_options(
    show_legend = TRUE,
    fontsize_barplot_y_numbers = 12,
    legend_text_size = 16,
    legend_key_size = 1,
    legend_nrow = 1,
  )
)

}
