% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_chernoff.R
\name{geom_chernoff}
\alias{geom_chernoff}
\title{Chernoff faces in ggplot2}
\usage{
geom_chernoff(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}} or
\code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
A \code{\link[ggplot2:Geom]{Geom}} layer object for use with \code{ggplot2}.
}
\description{
The Chernoff geom is used to create data visualisations in the shape of human-like faces.
By mapping to the relevant aesthetics, faces can appear to vary in happiness, anger, size, colour and so on.
}
\section{Aesthetics}{

\code{geom_chernoff} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{colour}
\item \code{fill}
\item \code{size}
}
The following aesthetics are unique to \code{geom_chernoff}:
\itemize{
\item \code{smile}
\item \code{brow}
\item \code{nose}
\item \code{eyes}
}
For details, see \code{\link{chernoffGrob}}.
}

\examples{
library(ggplot2)
ggplot(iris, aes(Sepal.Width, Sepal.Length, smile = Petal.Length, fill = Species)) +
  geom_chernoff()

ggplot(data.frame(x = 1:4,
                  y = c(3:1, 2.5),
                  z = factor(1:4),
                  w = rnorm(4),
                  n = c(rep(FALSE, 3), TRUE)
                  )) +
    aes(x, y, fill = z, size = x, nose = n, smile = w) +
    geom_chernoff()

}
\references{
Chernoff, H. (1973).
The use of faces to represent points in \emph{k}-dimensional space graphically.
\emph{Journal of the American Statistical Association, 68}(342), 361–368.
}
\seealso{
\code{\link{chernoffGrob}}
}
