% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_eyes.R
\name{scale_eyes_continuous}
\alias{scale_eyes_continuous}
\alias{scale_eyes}
\title{Scales for eye separation}
\usage{
scale_eyes_continuous(..., range = c(0.1, 2), midpoint = mean)

scale_eyes(..., range = c(0.1, 2), midpoint = mean)
}
\arguments{
\item{...}{Other arguments passed onto \code{\link[ggplot2]{continuous_scale}} to control name, limits, breaks, labels and so forth.}

\item{range}{Output range of eye distances. 0 corresponds to a cyclops and +1 to a 'normal' distance.}

\item{midpoint}{A value or function of your data that will return a 'normal' separation}
}
\value{
A \code{\link[ggplot2:continuous_scale]{Scale}} layer object for use with \code{ggplot2}.
}
\description{
\code{scale_eyes} lets you customise how eye separation is determined from your data.
It also lets you tweak the appearance of legends and so on.
}
\details{
Use \code{range} to vary how happily/sadly your maximum/minimum values are represented.
Minima smaller than -1 and maxima greater than +1 are possible but might look odd!
You can use \code{midpoint} to set a specific 'zero' value in your data or to have eye width represented as relative to average.

The function \code{scale_eyes} is an alias of \code{scale_eyes_continuous}.

Legends are a work in progress. In particular, \code{size} mappings might produce odd results.
}
\examples{
library(ggplot2)
p <- ggplot(iris) +
    aes(Sepal.Width, Sepal.Length, fill = Species, eyes = Sepal.Length) +
    geom_chernoff()
p
p + scale_eyes_continuous(midpoint = min)
p + scale_eyes_continuous(range = c(0, 2))

}
\seealso{
\code{\link{geom_chernoff}}, \code{\link{scale_brow}}, \code{\link{scale_smile}}
}
