% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_rsm.R
\name{gg_rsm}
\alias{gg_rsm}
\title{Contour plot(s) of a fitted linear model in ggplot2}
\usage{
gg_rsm(
  rsm_model,
  formula,
  decode = FALSE,
  n_columns = 2,
  text_size = 3,
  bins = 6,
  ...
)
}
\arguments{
\item{rsm_model}{Model of class "rsm"}

\item{formula}{A formula, or a list of formulas}

\item{decode}{This has an effect only if x is an rsm object or other model object that supports coded.data.
In such cases, if decode is TRUE, the coordinate axes are transformed to their decoded values.}

\item{n_columns}{number of columns for grid layout. Default is 2}

\item{text_size}{size of text for labelled contour lines. Default is 3}

\item{bins}{Number of contour bins. Overridden by binwidth}

\item{...}{Other arguments passed on to contour(). For help with more arguments see ?rsm::contour.lm}
}
\value{
A grid of contour plot(s) of a fitted linear model in 'ggplot2'
}
\description{
Contour plot(s) of a fitted linear model in ggplot2
}
\examples{
\dontrun{
heli.rsm <- rsm::rsm(ave ~ SO(x1, x2, x3),data = rsm::heli)

gg_rsm(heli.rsm,formula = ~x1+x2+x3,at = rsm::xs(heli.rsm),n_columns=3)

}
}
