% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resid_xpanel.R
\name{resid_xpanel}
\alias{resid_xpanel}
\title{Panel of Plots of Residuals or Response Variable versus Predictor Variables.}
\usage{
resid_xpanel(model, yvar = "residual", type = NA, smoother = FALSE,
  scale = 1, theme = "bw", axis.text.size = 10,
  title.text.size = 12, title.opt = TRUE, nrow = NULL)
}
\arguments{
\item{model}{Model fit using either \code{lm}, \code{glm}, \code{lmer},
\code{lmerTest}, \code{lme}, or \code{glmer}.}

\item{yvar}{Specifies the variable to put on the y-axis of the plots. Options
are "residual" (default) or "response".}

\item{type}{Type of residuals to use in the plot. If not specified, the
default residual type for each model type is used. (See details for the
options available.)}

\item{smoother}{Indicates whether or not to include a smoother on the
plots. Specify TRUE or FALSE. Default is set to FALSE.}

\item{scale}{Scales the size of the graphs in the panel. Takes values in (0,1].}

\item{theme}{ggplot2 theme to be used. Current options are \code{"bw"},
\code{"classic"}, and \code{"grey"} (or \code{"gray"}). Default is
\code{"bw"}.}

\item{axis.text.size}{Specifies the size of the text for the axis labels of
all plots in the panel.}

\item{title.text.size}{Specifies the size of the text for the titles of all
plots in the panel.}

\item{title.opt}{Indicates whether or not to include a title on the plots in
the panel. Specify TRUE or FALSE. Default is set to TRUE.}

\item{nrow}{Sets the number of rows in the panel.}
}
\value{
A panel of plots of the residuals or response variable versus the
predictor variables.
}
\description{
Creates a panel of plots of the residuals or response variable versus the
predictor (x) variables in the model. Interactions between predictor variables
are not included. Currently accepts models of type "lm", "glm", "lmerMod",
"lmerModLmerTest", "lme", and "glmerMod".
}
\details{
Note that for x variables that are factors, the levels shown on the
x-axis will be in the order that the levels are ordered in the dataframe.
This can be adjusted by reordering the levels of the factor before the model
is fit.
}
\examples{

# Fit a model to the penguin data
penguin_model <- lme4::lmer(heartrate ~ depth + duration + (1|bird), data = penguins)

# Create plots of the residuals versus the predictor variables
resid_xpanel(penguin_model, theme = "classic")

# Create plots of the response variable versus the predictor variables
resid_xpanel(penguin_model, yvar = "response", theme = "classic", smoother = TRUE)
}
