% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-free-align.R,
%   R/alignpatch-free-border.R, R/alignpatch-free-guide.R,
%   R/alignpatch-free-lab.R, R/alignpatch-free-space.R, R/alignpatch-free-vp.R
\name{free_align}
\alias{free_align}
\alias{free_border}
\alias{free_guide}
\alias{free_lab}
\alias{free_space}
\alias{free_vp}
\title{Free from alignment}
\usage{
free_align(plot, axes = "tlbr")

free_border(plot, borders = "tlbr")

free_guide(plot, guides = "tlbr")

free_lab(plot, labs = "tlbr")

free_space(plot, spaces = "tlbr")

free_vp(plot, x = 0.5, y = 0.5, width = NA, height = NA, ...)
}
\arguments{
\item{plot}{A \link[ggplot2:ggplot]{ggplot} or \link[=align_plots]{alignpatches}
object.}

\item{axes}{Which axes shouldn't be aligned? A string containing
one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"}.}

\item{borders}{Which border shouldn't be aligned? A string containing one or
more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"}.}

\item{guides}{A string containing one or more of
\code{"t"}, \code{"l"}, \code{"b"}, \code{"r"}, and \code{"i"} indicates which side of guide legends should be
collected for the plot. If \code{NULL}, no guide legends will be collected.}

\item{labs}{Which axis labs to be free? A string containing one or more of
\code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"}.}

\item{spaces}{Which border spaces should be removed? A string containing one
or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"}.}

\item{x}{A numeric vector or unit object specifying x-location.}

\item{y}{A numeric vector or unit object specifying y-location.}

\item{width}{A numeric vector or unit object specifying width.}

\item{height}{A numeric vector or unit object specifying height.}

\item{...}{
  Arguments passed on to \code{\link[grid:viewport]{grid::viewport}}
  \describe{
    \item{\code{default.units}}{A string indicating the default units to use
    if \code{x}, \code{y}, \code{width}, or \code{height}
    are only given as numeric vectors.}
    \item{\code{just}}{A string or numeric
    vector specifying the justification of the viewport
    relative to its (x, y) location.  If there are two values, the first
    value specifies horizontal justification and the second value specifies
    vertical justification.  Possible string values are: \code{"left"},
    \code{"right"}, \code{"centre"}, \code{"center"}, \code{"bottom"},
    and \code{"top"}.  For numeric values, 0 means left alignment
    and 1 means right alignment.
  }
    \item{\code{gp}}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}
    \item{\code{clip}}{One of \code{"on"}, \code{"inherit"}, or
    \code{"off"}, indicating whether to
    clip to the extent of this viewport, inherit the clipping region
    from the parent viewport, or turn clipping off altogether.
    For back-compatibility, a logical value of \code{TRUE} corresponds
    to \code{"on"} and \code{FALSE} corresponds to \code{"inherit"}.

    May also be a grob (or a gTree) that describes a clipping path
    or the result of a call to \code{\link[grid]{as.path}}.}
    \item{\code{mask}}{One of \code{"none"} (or \code{FALSE})
    or \code{"inherit"} (or \code{TRUE}) 
    or a grob (or a gTree) or the result of call to
    \code{\link[grid]{as.mask}}.  This specifies that the viewport
    should have no mask, or it should inherit the mask of its parent,
    or it should have its own mask, as described by the grob.}
    \item{\code{xscale}}{A numeric vector of length two indicating the minimum and
    maximum on the x-scale.  The limits may not be identical. }
    \item{\code{yscale}}{A numeric vector of length two indicating the minimum
    and maximum on the y-scale. The limits may not be identical. }
    \item{\code{angle}}{A numeric value indicating the angle of rotation of the
    viewport.  Positive values indicate the amount of rotation, in
    degrees, anticlockwise from the positive x-axis.}
    \item{\code{layout}}{A Grid layout object which splits the viewport into
    subregions.}
    \item{\code{layout.pos.row}}{A numeric vector giving the
    rows occupied by this viewport in its
    parent's layout.}
    \item{\code{layout.pos.col}}{A numeric vector giving the
    columns occupied by this viewport in its
    parent's layout.}
    \item{\code{name}}{A character value to uniquely identify the viewport
    once it has been pushed onto the viewport tree.  }
  }}
}
\value{
\itemize{
\item \code{free_align}: A modified version of \code{plot} with a \code{ggalign_free_align}
class.
}

\itemize{
\item \code{free_border}: A modified version of \code{plot} with a \code{ggalign_free_border}
class.
}

\itemize{
\item \code{free_guide}: A modified version of \code{plot} with a \code{ggalign_free_guide}
class.
}

\itemize{
\item \code{free_lab}: A modified version of \code{plot} with a \code{ggalign_free_lab} class.
}

\itemize{
\item \code{free_space}: A modified version of \code{plot} with a \code{ggalign_free_space}
class.
}

\itemize{
\item \code{free_vp}: A modified version of \code{plot} with a \code{ggalign_free_vp} class.
}
}
\description{
\link{align_plots} will try to align plot panels, and every elements of the plot,
following functions romove these restrictions:
\itemize{
\item \code{free_align}: if we want to compose plots without alignment of some panel
axes (panel won't be aligned). we can wrap the plot with \code{free_align}.
\item \code{free_border}: attaches borders (e.g., axis titles, tick marks) directly to
the plot panel. This keeps them visually close to the panel during
alignment.
\item \code{free_lab()}: Similar to \code{free_border()}, but only attaches axis titles
and tick labels, not full borders. It's mainly included for completeness;
in most cases, combining \code{free_border()} and \code{free_space()} is sufficient.
\item \code{free_space}: Removing the ggplot element sizes when aligning.
\item \code{free_vp}: Customize the \link[grid:viewport]{viewport} when aligning.
\item \code{free_guide}: If we want to override the behaviour of the overall guides
behaviour, we can wrap the plot with \code{free_guide}.
}
}
\examples{
# directly copied from `patchwork`
# Sometimes you have a plot that defies good composition alginment, e.g. due
# to long axis labels
p1 <- ggplot(mtcars) +
    geom_bar(aes(y = factor(gear), fill = factor(gear))) +
    scale_y_discrete(
        "",
        labels = c(
            "3 gears are often enough",
            "But, you know, 4 is a nice number",
            "I would def go with 5 gears in a modern car"
        )
    )

# When combined with other plots it ends up looking bad
p2 <- ggplot(mtcars) +
    geom_point(aes(mpg, disp))

align_plots(p1, p2, ncol = 1L)

# We can fix this be using `free_align`
align_plots(free_align(p1), p2, ncol = 1L)

# If we still want the panels to be aligned to the right, we can choose to
# free only the left side
align_plots(free_align(p1, axes = "l"), p2, ncol = 1L)

# We could use `free_lab` to fix the layout in a different way
align_plots(p1, free_lab(p2), ncol = 1L)

# `free_border` is similar with `free_lab`, they have a distinction in terms
# of placement on either the top or bottom side of the panel. Specifically,
# the top side contains the `title` and `subtitle`, while the bottom side
# contains the `caption`. free_lab() does not attach these elements in the
# panel area.
p3 <- ggplot(mtcars) +
    geom_point(aes(hp, wt, colour = mpg)) +
    ggtitle("Plot 3")
p_axis_top <- ggplot(mtcars) +
    geom_point(aes(mpg, disp)) +
    ggtitle("Plot axis in top") +
    scale_x_continuous(position = "top")
align_plots(p_axis_top, free_lab(p3))
align_plots(p_axis_top, free_border(p3))

# Another issue is that long labels can occupy much spaces
align_plots(NULL, p1, p2, p2)

# This can be fixed with `free_space`
align_plots(NULL, free_space(p1, "l"), p2, p2)

}
