% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{ggcharts_get_theme}
\alias{ggcharts_get_theme}
\alias{ggcharts_set_theme}
\title{Get and Set the Currently Active ggcharts Theme}
\usage{
ggcharts_get_theme()

ggcharts_set_theme(theme, ...)
}
\arguments{
\item{theme}{\code{character}. The name of the theme, e.g. \code{"theme_hermit"}}

\item{...}{Additional argument passed onto the specified \code{theme}}
}
\value{
\code{ggchart_set_theme} invisibly returns the name of the previously active
theme as a \code{character}. \code{ggchart_get_theme} returns the name of the
currently active theme as a \code{character}.
}
\description{
The current theme is automatically applied to any plot created with
\code{ggcharts}. It does not affect plots created with \code{ggplot2}.
}
\examples{
data("diamonds", package = "ggplot2")

## By default `theme_ggcharts()` is used
ggcharts_get_theme()
bar_chart(diamonds, cut)

ggcharts_set_theme("theme_hermit")
bar_chart(diamonds, cut)

ggcharts_set_theme("theme_ng")
bar_chart(diamonds, cut)

ggcharts_set_theme("theme_nightblue", base_size = 16, base_family = "serif")
bar_chart(diamonds, cut)

## Restore the default
ggcharts_set_theme("theme_ggcharts")

}
\author{
Thomas Neitmann
}
