% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_1d.R
\name{method_kde_1d}
\alias{method_kde_1d}
\title{Univariate kernel density HDR estimator}
\usage{
method_kde_1d(
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  weights = NULL,
  window = kernel
)
}
\arguments{
\item{bw}{the smoothing bandwidth to be used.  The kernels are scaled
    such that this is the standard deviation of the smoothing kernel.
    (Note this differs from the reference books cited below, and from S-PLUS.)

    \code{bw} can also be a character string giving a rule to choose the
    bandwidth.  See \code{\link[stats]{bw.nrd}}. \cr The default,
    \code{"nrd0"}, has remained the default for historical and
    compatibility reasons, rather than as a general recommendation,
    where e.g., \code{"SJ"} would rather fit, see also Venables and
    Ripley (2002).

    The specified (or computed) value of \code{bw} is multiplied by
    \code{adjust}.
  }

\item{adjust}{the bandwidth used is actually \code{adjust*bw}.
    This makes it easy to specify values like \sQuote{half the default}
    bandwidth.}

\item{kernel, window}{a character string giving the smoothing kernel
    to be used. This must partially match one of \code{"gaussian"},
    \code{"rectangular"}, \code{"triangular"}, \code{"epanechnikov"},
    \code{"biweight"}, \code{"cosine"} or \code{"optcosine"}, with default
    \code{"gaussian"}, and may be abbreviated to a unique prefix (single
    letter).

    \code{"cosine"} is smoother than \code{"optcosine"}, which is the
    usual \sQuote{cosine} kernel in the literature and almost MSE-efficient.
    However, \code{"cosine"} is the version used by S.
  }

\item{weights}{numeric vector of non-negative observation weights,
    hence of same length as \code{x}. The default \code{NULL} is
    equivalent to \code{weights = rep(1/nx, nx)} where \code{nx} is the
    length of (the finite entries of) \code{x[]}.  If \code{na.rm = TRUE}
    and there are \code{NA}'s in \code{x}, they \emph{and} the
    corresponding weights are removed before computations.  In that case,
    when the original weights have summed to one, they are re-scaled to
    keep doing so.}
}
\description{
Function used to specify univariate kernel density estimator
for \code{get_hdr_1d()} and layer functions (e.g. \code{geom_hdr_rug()}).
}
\details{
For more details on the use and implementation of the \verb{method_*_1d()} functions,
see \code{vignette("method", "ggdensity")}.
}
\examples{
df <- data.frame(x = rnorm(1e3, sd = 3))

ggplot(df, aes(x)) +
  geom_hdr_rug(method = method_kde_1d()) +
  geom_density()

# Details of the KDE can be adjusted with arguments to `method_kde_1d()`
ggplot(df, aes(x)) +
  geom_hdr_rug(method = method_kde_1d(adjust = 1/5)) +
  geom_density(adjust = 1/5)

ggplot(df, aes(x)) +
  geom_hdr_rug(method = method_kde_1d(kernel = "triangular")) +
  geom_density(kernel = "triangular")

# Can also be used with `get_hdr_1d()` for numerical summary of HDRs
res <- get_hdr_1d(df$x, method = method_kde_1d())
str(res)

}
