% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounder.R
\name{bounder_range}
\alias{bounder_range}
\title{Estimate bounds of a distribution using the range of the sample}
\usage{
bounder_range(x)
}
\arguments{
\item{x}{<\link{numeric}> Sample to estimate the bounds of.}
}
\value{
A length-2 numeric vector giving an estimate of the minimum and maximum bounds
of the distribution that \code{x} came from.
}
\description{
Estimate the bounds of the distribution a sample came from using the range of the sample.
Use with the \code{bounder} argument to \code{\link[=density_bounded]{density_bounded()}}.

Supports \link[=auto_partial]{automatic partial function application} with
\link[=waiver]{waived arguments}.
}
\details{
Estimate the bounds of a distribution using \code{range(x)}.
}
\seealso{
The \code{bounder} argument to \code{\link[=density_bounded]{density_bounded()}}.

Other bounds estimators: 
\code{\link{bounder_cdf}()},
\code{\link{bounder_cooke}()}
}
\concept{bounds estimators}
