% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/model_checks.R
\name{table_parameters}
\alias{table_parameters}
\alias{print_parameter_map}
\alias{model_parameter_utils}
\title{Tabulate Model Parameter}
\usage{
table_parameters(model_r, parameters_r)

print_parameter_map(model_r)
}
\arguments{
\item{model_r}{An S4 model object created by \code{BuildModel}.}

\item{parameters_r}{Numeric vector of parameter values (for `table_parameters` only)}
}
\value{
\describe{
  \item{table_parameters}{Returns a List in matrix form showing how parameters
map to model parameters}
  \item{print_parameter_map}{Prints the parameter mapping structure and
returns invisibly as integer status (0 for success)}
}
}
\description{
Functions for inspecting and displaying parameter structures in models
built with `ggdmcModel`.
}
\details{
These functions help analyse whether the parameter and the factor are
constructed as \code{BuildModel} specified:

\itemize{
  \item `table_parameters()` creates a tabular representation showing how
        parameters map to stimuli, responses, and other model components
  \item `print_parameter_map()` displays the model's parameter mapping.
}
}
\examples{
# Build a model first
model <- BuildModel(
    p_map = list(a = "1", v = "S", z = "1", d = "1", sz = "1", sv = "1", t0 = "1", 
                 st0 = "1", s = "1"),
    match_map = list(M = list(s1 = "r1", s2 = "r2")),
    factors = list(S = c("s1", "s2")),
    constants = c(d = 1, s = 1, sv = 1, sz = 0.5, st0 = 0),
    accumulators = c("r1", "r2"),
    type = "fastdm"
)

# Tabulate a parameter vector to examine how the factor-dependent 
# drift rate maps to the condition, s1 and s2.
p_vector <- c(a = 1, sv = 0.2, sz = 0.25, t0 = 0.15, v.s1 = 4, v.s2 = 2, z = .38)

pmat <- table_parameters(model, p_vector)
# Transpose the result to get a more readable format
result <- lapply(pmat, function(x) {
    t(x)
})

print(result)
# $s1.r1
#    a d s st0 sv  sz  t0    v z
# r1 1 1 1   0  1 0.5 0.2 0.25 4
# r2 1 1 1   0  1 0.5 0.2 0.25 4
# 
# $s1.r2
#    a d s st0 sv  sz  t0    v z
# r1 1 1 1   0  1 0.5 0.2 0.25 4
# r2 1 1 1   0  1 0.5 0.2 0.25 4
# 
# $s2.r1
#    a d s st0 sv  sz  t0    v z
# r1 1 1 1   0  1 0.5 0.2 0.15 4
# r2 1 1 1   0  1 0.5 0.2 0.15 4
# 
# $s2.r2
#    a d s st0 sv  sz  t0    v z
# r1 1 1 1   0  1 0.5 0.2 0.15 4
# r2 1 1 1   0  1 0.5 0.2 0.15 4

# Print the parameter map 
tmp <- print_parameter_map(model)
# All parameters: a       d       s       st0     sv      sz      t0
#                 v.s1    v.s2    z
# Core parameters: a      d       s       st0     sv      sz      t0     
#                  v       z
# Free parameters: a      t0      v.s1    v.s2    z
# Constant values: d: 1   s: 1    st0: 0  sv: 1   sz: 0.5

# Parameter map: 
# 
# 1. When the second row is 1, it indicates that the parameter is fixed.
# The internal machinery goes to the 'constant' to find its value. Note
# the constant will be sorted alphabetically.
# 2. When the second row is 0, it indicates that the parameter is free.
# The internal machinery goes to the p_vector to find its value.
# When doing MCMC sampling, a new p_vector is proposed by the sampler at 
# every iteration.

# Cell, s1.r1:
# Acc 0: 0 0 1 2 3 4 1 2 4 <- C++ index 
#        1 0 0 0 0 0 1 1 1 <- Whether the parameter is fixed
# Acc 1: 0 0 1 2 3 4 1 2 4 
#        1 0 0 0 0 0 1 1 1 
# 
# Cell, s1.r2:
# Acc 0: 0 0 1 2 3 4 1 2 4 
#        1 0 0 0 0 0 1 1 1 
# Acc 1: 0 0 1 2 3 4 1 2 4 
#        1 0 0 0 0 0 1 1 1 
# 
# Cell, s2.r1:
# Acc 0: 0 0 1 2 3 4 1 3 4 
#        1 0 0 0 0 0 1 1 1 
# Acc 1: 0 0 1 2 3 4 1 3 4 
#        1 0 0 0 0 0 1 1 1 
# 
# Cell, s2.r2:
# Acc 0: 0 0 1 2 3 4 1 3 4 
#        1 0 0 0 0 0 1 1 1 
# Acc 1: 0 0 1 2 3 4 1 3 4 
#        1 0 0 0 0 0 1 1 1 
# 
# Cell (ncell =  4): s1.r1        s1.r2   s2.r1   s2.r2

}
