% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_circle.R
\name{geom_mark_circle}
\alias{geom_mark_circle}
\title{Annotate areas with circles}
\usage{
geom_mark_circle(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  expand = unit(5, "mm"),
  radius = expand,
  n = 100,
  label.margin = margin(2, 2, 2, 2, "mm"),
  label.width = NULL,
  label.minwidth = unit(50, "mm"),
  label.hjust = 0,
  label.fontsize = 12,
  label.family = "",
  label.lineheight = 1,
  label.fontface = c("bold", "plain"),
  label.fill = "white",
  label.colour = "black",
  label.buffer = unit(10, "mm"),
  con.colour = "black",
  con.size = 0.5,
  con.type = "elbow",
  con.linetype = 1,
  con.border = "one",
  con.cap = unit(3, "mm"),
  con.arrow = NULL,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{expand}{A numeric or unit vector of length one, specifying the
expansion amount. Negative values will result in contraction instead. If the
value is given as a numeric it will be understood as a proportion of the
plot area width.}

\item{radius}{As \code{expand} but specifying the corner radius.}

\item{n}{The number of points used to draw each circle. Defaults to \code{100}.}

\item{label.margin}{The margin around the annotation boxes, given by a call
to \code{\link[ggplot2:element]{ggplot2::margin()}}.}

\item{label.width}{A fixed width for the label. Set to \code{NULL} to let the text
or \code{label.minwidth} decide.}

\item{label.minwidth}{The minimum width to provide for the description. If
the size of the label exceeds this, the description is allowed to fill as
much as the label.}

\item{label.hjust}{The horizontal justification for the annotation. If it
contains two elements the first will be used for the label and the second for
the description.}

\item{label.fontsize}{The size of the text for the annotation. If it contains
two elements the first will be used for the label and the second for the
description.}

\item{label.family}{The font family used for the annotation. If it contains
two elements the first will be used for the label and the second for the
description.}

\item{label.lineheight}{The height of a line as a multipler of the fontsize.
If it contains two elements the first will be used for the label and the
second for the description.}

\item{label.fontface}{The font face used for the annotation. If it contains
two elements the first will be used for the label and the second for the
description.}

\item{label.fill}{The fill colour for the annotation box. Use \code{"inherit"} to
use the fill from the enclosure or \code{"inherit_col"} to use the border colour
of the enclosure.}

\item{label.colour}{The text colour for the annotation. If it contains
two elements the first will be used for the label and the second for the
description. Use \code{"inherit"} to use the border colour of the enclosure or
\code{"inherit_fill"} to use the fill colour from the enclosure.}

\item{label.buffer}{The size of the region around the mark where labels
cannot be placed.}

\item{con.colour}{The colour for the line connecting the annotation to the
mark. Use \code{"inherit"} to use the border colour of the enclosure or
\code{"inherit_fill"} to use the fill colour from the enclosure.}

\item{con.size}{The width of the connector. Use \code{"inherit"} to use the border
width of the enclosure.}

\item{con.type}{The type of the connector. Either \code{"elbow"}, \code{"straight"}, or
\code{"none"}.}

\item{con.linetype}{The linetype of the connector. Use \code{"inherit"} to use the
border linetype of the enclosure.}

\item{con.border}{The bordertype of the connector. Either \code{"one"} (to draw a
line on the horizontal side closest to the mark), \code{"all"} (to draw a border
on all sides), or \code{"none"} (not going to explain that one).}

\item{con.cap}{The distance before the mark that the line should stop at.}

\item{con.arrow}{An arrow specification for the connection using
\code{\link[grid:arrow]{grid::arrow()}} for the end pointing towards the mark.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
This geom lets you annotate sets of points via circles. The enclosing circles
are calculated at draw time and the most optimal enclosure at the given
aspect ratio is thus guaranteed. As with the other \verb{geom_mark_*} geoms the
enclosure inherits from \code{\link[=geom_shape]{geom_shape()}} and defaults to be expanded slightly
to better enclose the points.
}
\section{Annotation}{

All \verb{geom_mark_*} allow you to put descriptive textboxes connected to the
mark on the plot, using the \code{label} and \code{description} aesthetics. The
textboxes are automatically placed close to the mark, but without obscuring
any of the datapoints in the layer. The placement is dynamic so if you resize
the plot you'll see that the annotation might move around as areas become big
enough or too small to fit the annotation. If there's not enough space for
the annotation without overlapping data it will not get drawn. In these cases
try resizing the plot, change the size of the annotation, or decrease the
buffer region around the marks.
}

\section{Filtering}{

Often marks are used to draw attention to, or annotate specific features of
the plot and it is thus not desirable to have marks around everything. While
it is possible to simply pre-filter the data used for the mark layer, the
\verb{geom_mark_*} geoms also comes with a dedicated \code{filter} aesthetic that, if
set, will remove all rows where it evalutates to \code{FALSE}. There are
multiple benefits of using this instead of prefiltering. First, you don't
have to change your data source, making your code more adaptable for
exploration. Second, the data removed by the filter aesthetic is remembered
by the geom, and any annotation will take care not to overlap with the
removed data.
}

\section{Aesthetics}{

geom_mark_circle understand the following aesthetics (required aesthetics are
in bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item x0 \emph{(used to anchor the label)}
\item y0 \emph{(used to anchor the label)}
\item filter
\item label
\item description
\item color
\item fill
\item group
\item size
\item linetype
\item alpha
}
}

\examples{
ggplot(iris, aes(Petal.Length, Petal.Width)) +
  geom_mark_circle(aes(fill = Species, filter = Species != 'versicolor')) +
  geom_point()

# Add annotation
ggplot(iris, aes(Petal.Length, Petal.Width)) +
  geom_mark_circle(aes(fill = Species, label = Species)) +
  geom_point()

# Long descriptions are automatically wrapped to fit into the width
iris$desc <- c(
  'A super Iris - and it knows it',
  'Pretty mediocre Iris, but give it a couple of years and it might surprise you',
  "You'll never guess what this Iris does every Sunday"
)[iris$Species]

ggplot(iris, aes(Petal.Length, Petal.Width)) +
  geom_mark_circle(aes(fill = Species, label = Species, description = desc,
                       filter = Species == 'setosa')) +
  geom_point()

# Change the buffer size to move labels farther away (or closer) from the
# marks
ggplot(iris, aes(Petal.Length, Petal.Width)) +
  geom_mark_circle(aes(fill = Species, label = Species),
                   label.buffer = unit(30, 'mm')) +
  geom_point()

# The connector is capped a bit before it reaches the mark, but this can be
# controlled
ggplot(iris, aes(Petal.Length, Petal.Width)) +
  geom_mark_circle(aes(fill = Species, label = Species),
                   con.cap = 0) +
  geom_point()

# If you want to use the scaled colours for the labels or connectors you can
# use the "inherit" keyword instead
ggplot(iris, aes(Petal.Length, Petal.Width)) +
  geom_mark_circle(aes(fill = Species, label = Species),
                   label.fill = "inherit") +
  geom_point()

}
\seealso{
Other mark geoms: 
\code{\link{geom_mark_ellipse}()},
\code{\link{geom_mark_hull}()},
\code{\link{geom_mark_rect}()}
}
\concept{mark geoms}
