% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_helpers.R
\name{build_sf_inset_layers}
\alias{build_sf_inset_layers}
\title{Build layers to implement an inset-compatible geometry}
\usage{
build_sf_inset_layers(
  data,
  mapping,
  stat,
  position,
  show.legend,
  inherit.aes,
  params,
  inset,
  map_base = "normal",
  map_inset = "auto"
)
}
\arguments{
\item{data, mapping, stat, position, show.legend, inherit.aes, params}{See \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{inset}{Inset configuration; see \code{\link[=configure_inset]{configure_inset()}}.
If \code{NA} (the default), this is inherited from the coord (see \code{\link[=coord_sf_inset]{coord_sf_inset()}}).}

\item{map_base}{Controls the layer with the base map. Possible values are
\code{"normal"} to create a layer as though the inset were not specified,
\code{"clip"} to create a layer with the inset viewport cut out, and
\code{"none"} to prevent the insertion of a layer for the base map.}

\item{map_inset}{Controls the layer with the inset map. Possible values are
\code{"auto"} to choose the behaviour based on whether \code{inset} is specified,
\code{"normal"} to create a layer with the viewport cut out and transformed, and
\code{"none"} to prevent the insertion of a layer for the viewport map.}
}
\value{
A \code{ggplot} layer, or a pair of layers.
}
\description{
For plotting, use \code{\link[=geom_sf_inset]{geom_sf_inset()}} instead. This helper is intended to be used when
implementing custom geometries based on \code{\link[=geom_sf_inset]{geom_sf_inset()}} so that they can provide
parameters to control the inset.
}
\examples{
my_custom_geom <- function(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "my_custom_stat",
  position = "identity",
  ...,
  inset = NA,
  map_base = "normal",
  map_inset = "auto",
  na.rm = TRUE,
  inherit.aes = TRUE
) {
  params <- rlang::list2(na.rm = na.rm, ...)
  build_sf_inset_layers(
    data = data, mapping = mapping,
    stat = stat, position = position,
    show.legend = show.legend,
    inherit.aes = inherit.aes,
    params = params,
    inset = inset,
    map_base = map_base,
    map_inset = map_inset
  )
}
}
