% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.ggmix_fit}
\alias{predict.ggmix_fit}
\alias{coef.ggmix_fit}
\title{Make predictions from a \code{ggmix_fit} object}
\usage{
\method{predict}{ggmix_fit}(
  object,
  newx,
  s = NULL,
  type = c("link", "response", "coefficients", "all", "nonzero", "individual"),
  covariance,
  ...
)

\method{coef}{ggmix_fit}(object, s = NULL, type, ...)
}
\arguments{
\item{object}{Fitted \code{ggmix_fit} model object from the
\code{\link{ggmix}} function}

\item{newx}{matrix of values for \code{x} at which predictions are to be
made. Do not include the intercept. Must be a matrix. This argument is not
used for \code{type = c("coefficients","nonzero","all")}. This matrix must
have the same number of columns originally supplied to the
\code{\link{ggmix}} fitting function.}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which predictions
are required. Default is the entire sequence used to create the model.}

\item{type}{Type of prediction required. Type \code{"link"} gives the fitted
values \eqn{X \beta}. Type \code{"response"} is equivalent to type
\code{"link"}. Type \code{"coefficients"} computes the coefficients at the
requested values for \code{s} and returns the regression coefficients only,
including the intercept. Type \code{"all"} returns both the regression
coefficients and variance components at the requested value of \code{s}.
Type \code{"nonzero"} returns a 1 column matrix of the the nonzero fixed
effects, as well as variance components for each value of \code{s}. If more
than one \code{s} is provided, then \code{"nonzero"} will return a list of
1 column matrices. Default: "link"}

\item{covariance}{covariance between test and training individuals. if there
are q testing individuals and N-q training individuals, then this
covariance matrix is q x (N-q)}

\item{...}{additional arguments to pass to predict function}
}
\value{
The object returned depends on type.
}
\description{
Similar to other predict methods, this functions predicts fitted
  values, coefficients and more from a fitted \code{ggmix_fit} object.
}
\details{
\code{s} is the new vector at which predictions are requested. If
  \code{s} is not in the lambda sequence used for fitting the model, the
  predict function will use linear interpolation to make predictions. The new
  values are interpolated using a fraction of predicted values from both left
  and right lambda indices. \code{coef(...)} is equivalent to
  \code{predict(ggmix_fit, type="coefficients",...)}. To get individual level
  predictions at each value of lambda, you must provide the lambda sequence
  to the s argument. You can pass either a ggmix_fit or ggmix_gic object. See
  examples for more details.
}
\examples{
data("admixed")
fitlmm <- ggmix(x = admixed$xtrain, y = admixed$ytrain,
                kinship = admixed$kin_train,
                estimation = "full")
bicGGMIX <- gic(fitlmm,
                an = log(length(admixed$ytrain)))
plot(bicGGMIX)
coef(bicGGMIX, s = "lambda.min")
yhat_test <- predict(bicGGMIX, s="lambda.min",
                     newx = admixed$xtest, type = "individual",
                     covariance = admixed$kin_test_train)
cor(yhat_test, admixed$ytest)
yhat_test_population <- predict(bicGGMIX, s="lambda.min",
                                newx = admixed$xtest,
                                type = "response")
}
