% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_gsea.R
\name{pathway_gsea}
\alias{pathway_gsea}
\title{Gene Set Enrichment Analysis for PICRUSt2 output}
\usage{
pathway_gsea(
  abundance,
  metadata,
  group,
  pathway_type = "KEGG",
  method = "fgsea",
  rank_method = "signal2noise",
  nperm = 1000,
  min_size = 10,
  max_size = 500,
  p.adjust = "BH",
  seed = 42,
  go_category = "BP"
)
}
\arguments{
\item{abundance}{A data frame containing KO/EC/MetaCyc abundance data, with features as rows and samples as columns}

\item{metadata}{A data frame containing sample metadata}

\item{group}{A character string specifying the column name in metadata that contains the grouping variable}

\item{pathway_type}{A character string specifying the pathway type: "KEGG", "MetaCyc", or "GO"}

\item{method}{A character string specifying the GSEA method: "fgsea", "GSEA", or "clusterProfiler"}

\item{rank_method}{A character string specifying the ranking statistic: "signal2noise", "t_test", "log2_ratio", or "diff_abundance"}

\item{nperm}{An integer specifying the number of permutations}

\item{min_size}{An integer specifying the minimum gene set size}

\item{max_size}{An integer specifying the maximum gene set size}

\item{p.adjust}{A character string specifying the p-value adjustment method}

\item{seed}{An integer specifying the random seed for reproducibility}

\item{go_category}{A character string specifying the GO category: "BP" (Biological Process), "MF" (Molecular Function), or "CC" (Cellular Component). Only used when pathway_type = "GO". Default is "BP".}
}
\value{
A data frame containing GSEA results
}
\description{
This function performs Gene Set Enrichment Analysis (GSEA) on PICRUSt2 predicted functional data
to identify enriched pathways between different conditions.
}
\examples{
\dontrun{
# Load example data
data(ko_abundance)
data(metadata)

# Prepare abundance data
abundance_data <- as.data.frame(ko_abundance)
rownames(abundance_data) <- abundance_data[, "#NAME"]
abundance_data <- abundance_data[, -1]

# Run GSEA analysis
gsea_results <- pathway_gsea(
  abundance = abundance_data,
  metadata = metadata,
  group = "Environment",
  pathway_type = "KEGG",
  method = "fgsea"
)

# Visualize results
visualize_gsea(gsea_results, plot_type = "enrichment_plot", n_pathways = 10)
}
}
