% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggrasp.cluster.R
\name{ggrasp.recluster}
\alias{ggrasp.recluster}
\title{ggrasp.recluster}
\usage{
ggrasp.recluster(x, z.limit = 1, min.lambda = 0.005, left.dist = 1)
}
\arguments{
\item{x}{the GGRaSP object for which the ranks will be added.}

\item{z.limit}{All Gaussian distributions with means within this number of standard deviations will be reduced to only the larger distribution. Defaults to 1. Set to 0 to keep all non-overlapping distributions.}

\item{min.lambda}{All Gaussian distributions with lambda value (proportion of the total distribution) below this value are removed before calculating the threshold. Default is 0.005. Set to 0 to keep all.}

\item{left.dist}{Number giving the number Gaussian distribution model immediately to the left of the threshold used. 1 is the default. Only value between 1 and k-1 where k is the total number of number of Gaussian distributions.}
}
\value{
A GGRaSP object with the recalculated thresholds and the medoids using a previously generated GMM
}
\description{
recalculates a threshold and the resulting cluster using the previously defined Gaussian Mixture Model and provided threshold-determining factors. Requires the ggrasp.cluster to already have run
}
\examples{
#The following data is from Chavda et al 2016 which phylotyped Enterobacter genomes
# Our example uses the data underpinning the tree shown in Figure 2

#Loading the tree 
library(ggrasp);
tree.file <- system.file("extdata", "Enter.kSNP.tree", package="ggrasp")
Enter.tree <- ggrasp.load(tree.file, file.format = "tree");

#Clustering the tree using a threshold estimated by Gaussian Mixture Models (GMMs)
\donttest{Enter.tree.cluster <- ggrasp.cluster(Enter.tree)}


#Use print to get a list of the medoids selected
\donttest{print(Enter.tree.cluster)}

#Re-clustering the tree using a threshold estimated by the GMMs but without the distribution
#cleaning (i.e. removing the overlapping and low count distributions)
\donttest{Enter.tree.reclust <- ggrasp.recluster(Enter.tree.cluster, z.limit=0, min.lambda = 0)}

}
