% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal_extender.R
\name{pal_extender}
\alias{pal_extender}
\alias{scale_fill_extended}
\alias{scale_colour_extended}
\title{Extend a discrete colour palette}
\usage{
pal_extender(pal = scales::brewer_pal(palette = "BrBG"))

scale_fill_extended(
  name = waiver(),
  ...,
  pal = scales::brewer_pal(palette = "BrBG"),
  aesthetics = "fill"
)

scale_colour_extended(
  name = waiver(),
  ...,
  pal = scales::brewer_pal(palette = "BrBG"),
  aesthetics = "colour"
)
}
\arguments{
\item{pal}{A palette function, such as returned by \link[scales:pal_brewer]{scales::brewer_pal},
taking a number of colours as entry and returning a list of colours.}

\item{name}{The name of the scale. Used as the axis or legend title.
If \code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be omitted.}

\item{...}{Other arguments passed on to \code{discrete_scale()} to control name,
limits, breaks, labels and so forth.}

\item{aesthetics}{Character string or vector of character strings listing
the name(s) of the aesthetic(s) that this scale works with. This can be
useful, for example, to apply colour settings to the colour and fill
aesthetics at the same time, via \code{aesthetics = c("colour", "fill")}.}
}
\value{
A palette function.
}
\description{
If the palette returns less colours than requested, the list of colours
will be expanded using \code{\link[scales:pal_gradient_n]{scales::pal_gradient_n()}}. To be used with a
sequential or diverging palette. Not relevant for qualitative palettes.
}
\examples{
pal <- scales::pal_brewer(palette = "PiYG")
scales::show_col(pal(16))
scales::show_col(pal_extender(pal)(16))
}
