% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histograms.R
\name{gghistweight3d_svy}
\alias{gghistweight3d_svy}
\title{Histogram of svy.design object with two facets}
\usage{
gghistweight3d_svy(surveyobj, x, y, z, binwidth = NULL)
}
\arguments{
\item{surveyobj}{svy.design object}

\item{x}{variable to histogram}

\item{y}{horizontal facet}

\item{z}{vertical facet}

\item{binwidth}{binwidth to pass to geom_hist}
}
\value{
ggplot object
}
\description{
In ggsurvey you specify both the plotting variables and weights in plain text with no quotes.
}
\examples{
library(survey)
data(api)
dstrat<-svydesign(id=~1,strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
gghistweight3d_svy(dstrat, api00, stype, awards)
gghistweight3d_svy(dstrat, api00, stype, awards, binwidth = 10)
}
