% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_survfit.R
\name{tidy_survfit}
\alias{tidy_survfit}
\title{Tidy a survfit object}
\usage{
tidy_survfit(
  x,
  times = NULL,
  type = c("survival", "risk", "cumhaz", "cloglog")
)
}
\arguments{
\item{x}{a 'survfit' object created with \code{survfit2()}}

\item{times}{numeric vector of times. Default is \code{NULL},
which returns all observed times.}

\item{type}{type of statistic to report.
Available for Kaplan-Meier estimates only.
Default is \code{"survival"}.
Must be one of the following or a function:\tabular{ll}{
   type \tab transformation \cr
   \code{"survival"} \tab \code{x} \cr
   \code{"risk"} \tab \code{1 - x} \cr
   \code{"cumhaz"} \tab \code{-log(x)} \cr
   \code{"cloglog"} \tab \code{log(-log(x))} \cr
}}
}
\value{
a tibble
}
\description{
The broom package exports a tidier for \code{"survfit"} objects.
This function adds on top of that and returns more information.
The function also utilizes additional information stored when the
survfit object is created with \code{survfit2()}.
It's recommended to always use this function with \code{survfit2()}.
}
\examples{
survfit2(Surv(time, status) ~ factor(ph.ecog), data = df_lung) \%>\%
  tidy_survfit()
}
