% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gicf.R
\name{gcgmloglik}
\alias{gcgmloglik}
\title{Gaussian Covariance Graphical Model Loglikelihood function}
\usage{
gcgmloglik(Sigma, S, n, lambda = 0, kappa = 0)
}
\arguments{
\item{Sigma}{The covariance matrix.}

\item{S}{The sample covariance matrix.}

\item{n}{The size of the observed dataset.}

\item{lambda}{A non-negative lasso parameter.}

\item{kappa}{A non-negative ridge regularisation parameter.}
}
\value{
The value of the penalised loglikelihood function.
}
\description{
Computes the penalised loglikelihood function of a Gaussian covariance graph model.
}
\details{
When imposing sparsity on the covariance matrix of a multivariate Gaussian distribution, the resulting
model can be interpreted as a covariance graphical model, i.e., the independence structure of the components
of the random vector can be encoded by a graph in which the nodes are identified with the variables and
a missing edge between two nodes implies that the corresponding variables are marginally independent.

In particular, this model admits both a ridge and a lasso penalty, resulting in the loglikelihood function
\deqn{-\text{log}|\Sigma| - \text{trace}(\Sigma^{-1}S) - \lambda\|\Sigma - \text{diag}(\Sigma)\|_1 - \kappa\|\Sigma^{-1}\|_1,}
where \eqn{\lambda, \kappa \geq 0}.
}
\examples{
# An example with a banded covariance matrix
library(mvtnorm)

set.seed(1234)

p <- 10
n <- 500

# Create banded covariance matrix with three bands
band1 <- cbind(1:(p - 1), 2:p)
band2 <- cbind(1:(p - 2), 3:p)
band3 <- cbind(1:(p - 3), 4:p)
idxs <- rbind(band1, band2, band3)

Sigma <- matrix(0, p, p)
Sigma[idxs] <- 0.5
Sigma <- Sigma + t(Sigma)
diag(Sigma) <- 2

# Generate data
data <- rmvnorm(n, sigma = Sigma)
S <- cov(data) * (n - 1)/n

# Fix a value of lambda and kappa
lambda <- 0.07
kappa <- 0.5

# Gaussian loglikelihood
print("Gaussian loglikelihood:")
print(gcgmloglik(Sigma, S, n))

# Penalised Gaussian loglikelihood
print("Penalised Gaussian loglikelihood:")
print(gcgmloglik(Sigma, S, n, lambda, kappa))
}
