% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankComp.R
\name{rankComp}
\alias{rankComp}
\title{Ranking Comparison}
\usage{
rankComp(ref, alt, highest.first = TRUE, id = NULL, time = NULL)
}
\arguments{
\item{ref}{a numeric vector of reference index values.}

\item{alt}{a numeric vector of alternative index values.}

\item{highest.first}{a logical value indicating whether the highest value
gets ranking #1. If \code{FALSE}, the lowest value gets ranking #1.}

\item{id}{a vector of unit identifiers.}

\item{time}{a vector of temporal factors.}
}
\value{
An object of classes \code{"rankComp"} and \code{"data.frame"} containing the following
columns:
\item{id}{the unit identifiers (if provided).}
\item{time}{the temporal factors (if provided).}
\item{ref.rank}{the ranking based on the reference index.}
\item{alt.rank}{the ranking based on the alternative index.}
\item{shift}{the ranking shifts between two indices.}
}
\description{
Perform a ranking comparison between two indices.
}
\examples{
data(bli)

# Goalpost normalization
bli.pol = c("neg", "pos", "pos", "pos", "pos", "neg",
            "pos", "pos", "pos", "neg", "pos")
bli.norm.2014 <- normalize(inds = bli[, 3:13], method = "goalpost",
                           ind.pol = bli.pol, time = bli$YEAR,
                           ref.time = 2014)

# Composite indices
ci.gini <- giniCI(bli.norm.2014, method = "gini",
                  ci.pol = "pos", time = bli$YEAR, ref.time = 2014,
                  only.ci = TRUE)
ci.reci <- giniCI(bli.norm.2014, method = "reci", agg = "geo",
                  ci.pol = "pos", time = bli$YEAR, ref.time = 2014,
                  only.ci = TRUE)

# Ranking comparison
ci.comp <- rankComp(ci.gini, ci.reci, id = bli$COUNTRY, time = bli$YEAR)
print(ci.comp)
summary(ci.comp)
}
\seealso{
\code{\link{summary.rankComp}}, \code{\link{rankScatterPlot}}, \code{\link{rankShiftPlot}},
\code{\link{rankRankPlot}}.
}
\author{
Viet Duong Nguyen, Chiara Gigliarano, Mariateresa Ciommi
}
