% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgin.R
\name{rgin}
\alias{rgin}
\title{Generating random numbers from the generalized inverse normal distribution}
\usage{
rgin(size, alpha, mu, tau, algo = "hormann", method = "Fortran")
}
\arguments{
\item{size}{number of desired draws. Output is numpy vector of length equal to size.}

\item{alpha}{degrees-of-freedom parameter.}

\item{mu}{similar to location parameter, controls asymmetry of the distribution.}

\item{tau}{similar to scale parameter, controls spread of the distribution.}

\item{algo}{string with desired algorithm to compute minimal bounding rectangle.
If "hormann", use the method from Hörmann and Leydold (2014). When "leydold", use the one from Leydold (2001).
Defaults to "hormann" and returns an error for any other values.}

\item{method}{string with the method used to compute the parabolic cylinder function
in the normalization constant. \code{method = "Fortran"} uses a compiled Fortran version,
which is the default. \code{method = "R"} uses an R translation of this function.}
}
\value{
Numeric vector of length \code{size}.
}
\description{
Generating random numbers from the generalized inverse normal distribution
}
\details{
Currently, only values of \code{alpha} > 2 are supported. For Bayesian posterior sampling,
\code{alpha} is always larger than 2 even for non-informative priors. The algorithm requires
calculating the probability of truncation region (either \code{z} < 0 or \code{z} > 0).
It is more stable to compute a probability bounded away from 0. As \code{mu} controls asymmetry,
when \code{mu} > 0, P(truncation region) = P(\code{z} > 0) >= 50\%, and this probability is computed.
If \code{mu} < 0, P(\code{z} < 0) >= 50\% and this region's probability is used.
}
\examples{
# Generate 1000 values from the distribution with alpha = 5, mu = 0, tau = 1
set.seed(123456)
z_unc <- rgin(1000, 5, 0, 1)

# Compare histogram to true density
z_vals <- seq(-5, 5, length.out = 200)
fz_unc <- sapply(z_vals, function(z) dgin(z, 5, 0, 1, FALSE))
temp <- hist(z_unc, breaks = 200, plot = FALSE)
plot(temp, freq = FALSE, xlim = c(-5, 5), ylim = range(c(fz_unc, temp$density)),
     main = '', xlab = 'Values', ylab = 'Density', col = 'blue')
lines(z_vals, fz_unc, col = 'red', lwd = 2)
}
