% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitr.R
\name{git}
\alias{git}
\alias{is_git}
\alias{git_version}
\title{Git Utilities}
\usage{
git(..., echo_cmd = TRUE)

is_git()

git_version()
}
\arguments{
\item{...}{Additional arguments passed to the system
command-line \verb{git <command> [<args>]} call.}

\item{echo_cmd}{\code{logical(1)}. Whether to print the
command to run to the console. Can be over-ridden
globally via \code{option(gitr_echo_cmd = FALSE)}.}
}
\value{
\code{\link[=git]{git()}}: The system call ... invisibly.

\code{is_git()}: \code{logical(1)}.

\code{git_version()}: \code{character(1)}.
The system version of \code{git}.
}
\description{
Provides functionality for system-level
Git commands from within R.
}
\section{Functions}{
\itemize{
\item \code{git()}: executes a \code{git} command line call from within R.

\item \code{is_git()}: is current working directory a \code{git} repository?

\item \code{git_version()}: gets the version of git in use.

}}
\examples{
\dontrun{
  git("status", "-s")

  git("reset", "--soft", "HEAD~1")

  git("tag", "-n")

  is_git()

  git_version()
}
}
