% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-anova.R
\name{anova.gkwreg}
\alias{anova.gkwreg}
\title{Analysis of Deviance for GKw Regression Models}
\usage{
\method{anova}{gkwreg}(object, ..., test = c("Chisq", "none"))
}
\arguments{
\item{object}{An object of class \code{"gkwreg"}, typically obtained from
\code{\link{gkwreg}}.}

\item{...}{Additional objects of class \code{"gkwreg"} for model comparison.
Models must be nested and fitted to the same dataset.}

\item{test}{A character string specifying the test statistic to use. Currently
only \code{"Chisq"} (default) is supported, which performs likelihood ratio
tests. Can also be \code{"none"} for no tests.}
}
\value{
An object of class \code{c("anova.gkwreg", "anova", "data.frame")},
with the following columns:
\describe{
\item{\code{Resid. Df}}{Residual degrees of freedom}
\item{\code{Resid. Dev}}{Residual deviance (-2 × log-likelihood)}
\item{\code{Df}}{Change in degrees of freedom (for model comparisons)}
\item{\code{Deviance}}{Change in deviance (for model comparisons)}
\item{\code{Pr(>Chi)}}{P-value from the chi-squared test (if \code{test = "Chisq"})}
}
}
\description{
Computes an analysis of deviance table for one or more fitted Generalized
Kumaraswamy (GKw) regression model objects. When multiple models are provided,
likelihood ratio tests are performed to compare nested models.
}
\details{
When a single model is provided, the function returns a table showing the
residual degrees of freedom and deviance.

When multiple models are provided, the function compares them using likelihood
ratio tests (LRT). Models are automatically ordered by their complexity
(degrees of freedom). The LRT statistic is computed as:
\deqn{LRT = 2(\ell_1 - \ell_0)}
where \eqn{\ell_1} is the log-likelihood of the more complex model and
\eqn{\ell_0} is the log-likelihood of the simpler (nested) model. Under the
null hypothesis that the simpler model is adequate, the LRT statistic follows
a chi-squared distribution with degrees of freedom equal to the difference in
the number of parameters between the models.

\strong{Important}: This method assumes that the models being compared are
nested (i.e., one model is a special case of the other) and fitted to the
same data. Comparing non-nested models or models fitted to different datasets
will produce unreliable results. Use \code{\link{AIC}} or \code{\link{BIC}}
for comparing non-nested models.

The deviance is defined as \eqn{-2 \times \text{log-likelihood}}. For models
fitted by maximum likelihood, smaller (more negative) deviances indicate
better fit. Note that deviance can be negative when the log-likelihood is
positive, which occurs when density values exceed 1 (common in continuous
distributions on bounded intervals). What matters for inference is the
\emph{change} in deviance between models, which should be positive when
the more complex model fits better.
}
\examples{
\donttest{
# Load example data
data(GasolineYield)

# Fit a series of nested models
fit1 <- gkwreg(yield ~ 1, data = GasolineYield, family = "kw")
fit2 <- gkwreg(yield ~ temp, data = GasolineYield, family = "kw")
fit3 <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")

# ANOVA table for single model
anova(fit3)

# Compare nested models using likelihood ratio tests
anova(fit1, fit2, fit3)
#> Model 1 vs 2: Adding temperature is highly significant (p < 0.001)
#> Model 2 vs 3: Adding batch is highly significant (p < 0.001)

# Compare two models
anova(fit2, fit3, test = "Chisq")

# Suppress test statistics
anova(fit1, fit2, fit3, test = "none")
}

}
\references{
Wilks, S. S. (1938). The large-sample distribution of the likelihood ratio
for testing composite hypotheses. \emph{The Annals of Mathematical Statistics},
\strong{9}(1), 60--62. \doi{10.1214/aoms/1177732360}

Pawitan, Y. (2001). \emph{In All Likelihood: Statistical Modelling and
Inference Using Likelihood}. Oxford University Press.
}
\seealso{
\code{\link{gkwreg}}, \code{\link{logLik.gkwreg}}, \code{\link{AIC.gkwreg}},
\code{\link{BIC.gkwreg}}, \code{\link{lrtest}}
}
\author{
Lopes, J. E.
}
