% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdoor.R
\name{gd_api}
\alias{gd_api}
\title{General Glassdoor API function}
\usage{
gd_api(
  query = NULL,
  action = NULL,
  agent = gd_user_agent(),
  version = 1,
  format = "json",
  url = gd_url(),
  pid = gd_pid(),
  pat = gd_pat(),
  ip_address = NULL,
  add_query = NULL,
  ...
)
}
\arguments{
\item{query}{Additional options to pass to the query other than those
specified here}

\item{action}{The particular API call that you would like to make}

\item{agent}{The User-Agent (browser) of the end user to whom the API
results will be shown. Note that you can can obtain this from the
"User-Agent" HTTP request header from the end-user}

\item{version}{The API version. The current version is 1 except for
jobs, which is currently version 1.1}

\item{format}{Either \code{xml} or \code{json} as you prefer}

\item{url}{Glassdoor RESTful API URL}

\item{pid}{Your partner id, as assigned by Glassdoor}

\item{pat}{Your partner key, as assigned by Glassdoor}

\item{ip_address}{The IP address of the end user to whom the API results will be shown}

\item{add_query}{Additional options to pass to the query other than those
specified here (named list)}

\item{...}{Additional options to send to \code{\link[httr]{GET}}}
}
\value{
A list of class \code{gd_api}
}
\description{
General Glassdoor API function
}
\examples{
if (have_gd_pid() && have_gd_pat()) {
res = gd_api(
action = "employers",
other = NULL,
  version = 1,
format = "json",
query =  "pharmaceuticals")

res = gd_api(
action = "employers",
other = NULL,
 version = 1,
format = "json",
query = "pharmaceuticals", config = list())
}
}
