% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodnessOfFit.gllvm.R
\name{goodnessOfFit}
\alias{goodnessOfFit}
\title{Goodness of fit measures for a gllvm}
\usage{
goodnessOfFit(
  y = NULL,
  pred = NULL,
  object = NULL,
  measure = c("cor", "RMSE", "MAE", "MARNE"),
  species = FALSE
)
}
\arguments{
\item{y}{a response matrix}

\item{pred}{predicted values for response matrix y}

\item{object}{an object of class 'gllvm'.}

\item{measure}{a goodness-of-fit measure to be calculated. Options are \code{"cor"} (correlation between observed and predicted values), \code{"scor"} (Spearman correlation between observed and predicted values), \code{"RMSE"} (root mean squared error of prediction), \code{"MAE"} (Mean Absolute Error), \code{"MARNE"} (Mean Absolute Range Normalized Error), \code{"TjurR2"} (Tjur's R2 measure, only for binary data), \code{"R2"} (R-squared as the square of the correlation) and \code{"sR2"} (R-squared as the square of the spearman correlation)}

\item{species}{logical, if \code{TRUE}, goodness-of-fit measures are calculated for each species separately. If FALSE,  goodness-of-fit measures are calculated for all species together.}
}
\description{
Several goodness-of-fit measure are currently available and can be calculated for a gllvm model fit and predicted values.
}
\details{
goodnessOfFit is used for evaluating the goodness-of-fit of a model or predictions. Available goodness-of-fit measures are correlation, RMSE, MARNE, and R2 measures. Definitions are below.
Denote an observed response j (species) at sample i, \eqn{i=1,...,n}, as \eqn{y_{ij}}, and predicted value as \eqn{\hat y_{ij}}.

\deqn{RMSE(\boldsymbol{y_{j}}, \boldsymbol{\hat y_{j}}) =  \sqrt{\frac{1}{n}\Sigma_{i=1}^{n} {(y_{ij} - \hat y_{ij})^2}} }

\deqn{MAE(\boldsymbol{y_{j}}, \boldsymbol{\hat y_{j}}) =  \frac{1}{n}\Sigma_{i=1}^{n} |y_{ij} - \hat y_{ij}| }

\deqn{MARNE(\boldsymbol{y_{j}}, \boldsymbol{\hat y_{j}}) =  \frac{1}{n}\Sigma_{i=1}^{n} \frac{|y_{ij} - \hat y_{ij}|}{max(\boldsymbol{y_{j}}) - min(\boldsymbol{y_{j}})} }

\deqn{Tjur's R2(\boldsymbol{y_{j}}, \boldsymbol{\hat y_{j}}) =  \frac{1}{n_1}\Sigma \hat y_{ij}\boldsymbol{1}_{y=1}(y_{ij}) - \frac{1}{n_0}\Sigma \hat y_{ij}\boldsymbol{1}_{y=0}(y_{ij}) }
}
\examples{
\dontrun{
# Fit gllvm model with Poisson family
data(microbialdata)
X <- microbialdata$Xenv
y <- microbialdata$Y[, order(colMeans(microbialdata$Y > 0), 
                     decreasing = TRUE)[21:40]]
fit <- gllvm(y, X, formula = ~ pH + Phosp, family = poisson())
# Calculate metrics
goodnessOfFit(object = fit, measure = c("cor", "RMSE"))

}
}
\seealso{
\code{\link{gllvm}}, \code{\link{predict.gllvm}}
}
\author{
Jenni Niku <jenni.m.e.niku@jyu.fi>
}
