% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Drosophila}
\alias{Drosophila}
\title{Developmental rate of Drosophila melanogaster}
\format{
A data frame with 23 rows and 3 variables:
\describe{
  \item{Temp}{a numeric vector indicating the temperature, in degrees Celsius.}
  \item{Duration}{a numeric vector indicating the average duration of the embryonic period, in hours, measured from the time at which the eggs were laid.}
  \item{Size}{a numeric vector indicating how many eggs each batch contained.}
}
}
\usage{
data(Drosophila)
}
\description{
\emph{Drosophila melanogaster} developmental stages were monitored as part of an experiment to determine the effect of temperature
on their duration. The eggs were laid at approximately 25 degrees Celsius and remained at that temperature for 20-30 minutes. The eggs were then
brought to the experimental temperature, which remained constant throughout the experiment.
}
\examples{
data(Drosophila)
dev.new()
with(Drosophila, plot(Temp,Duration,xlab="Temperature, in degrees Celsius",pch=16,col="blue",
                      ylab="Average duration of the embryonic period"))
}
\references{
Powsner L. (1935) The effects of temperature on the durations of the developmental stages of \emph{Drosophila melanogaster}.
            \emph{Physiological Zoology}, 8, 474-520.

McCullagh P., Nelder J.A. (1989). \emph{Generalized Linear Models. 2nd Edition}. Chapman and Hall, London.

Wei B.C. (1998). \emph{Exponential Family Nonlinear Models}. Springer, Singapore.
}
\keyword{datasets}
