% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{glossa_export}
\alias{glossa_export}
\title{Export Glossa Model Results}
\usage{
glossa_export(
  species = NULL,
  models = NULL,
  layer_results = NULL,
  fields = NULL,
  model_data = FALSE,
  model_summary = FALSE,
  fr = FALSE,
  prob_cut = FALSE,
  varimp = FALSE,
  cross_val = FALSE,
  layer_format = "tif",
  projections_results = NULL,
  presence_absence_list = NULL,
  other_results = NULL,
  pa_cutoff = NULL,
  config_snapshot = NULL
)
}
\arguments{
\item{species}{A character vector specifying the species names.}

\item{models}{A character vector specifying the types of models to export results for.}

\item{layer_results}{A list containing layer results for native range and suitable habitat predictions.}

\item{fields}{A character vector specifying the fields to include in the exported results.}

\item{model_data}{Logical, indicating whether to export model data.}

\item{fr}{Logical, indicating whether to export functional response results.}

\item{prob_cut}{Logical, indicating whether to export presence/absence probability cutoffs.}

\item{varimp}{Logical, indicating whether to export variable importance.}

\item{cross_val}{Logical, indicating whether to export cross-validation metrics.}

\item{layer_format}{A character vector specifying the format of the exported raster files.}

\item{projections_results}{A list containing projections results.}

\item{presence_absence_list}{A list containing presence/absence lists.}

\item{other_results}{A list containing other types of results (e.g., variable importance, functional responses, cross-validation).}

\item{pa_cutoff}{A list containing presence/absence probability cutoffs.}
}
\value{
A character vector of file paths for the exported files or directories.
}
\description{
This function exports various types of Glossa model results, including native range predictions, suitable habitat predictions, model data, variable importance, functional response results, and presence/absence probability cutoffs. It generates raster files for prediction results, TSV files for model data and variable importance, and TSV files for functional response results. Additionally, it creates a TSV file for presence/absence probability cutoffs if provided.
}
\keyword{internal}
