% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{map_colors}
\alias{map_colors}
\title{map_colors}
\usage{
map_colors(colors, x, min_limit=NULL, max_limit=NULL)
}
\arguments{
\item{colors}{A vector of colors}

\item{x}{A numeric vector of data}

\item{min_limit}{The minimum value to scale the color to. Must be outside the range of data. If NULL, the minimum is determined by the data.}

\item{max_limit}{The maximum value to scale the color to. Must be outside the range of data. If NULL, the maximum is determined by the data.}
}
\value{
A vector of colors.
}
\description{
A helper function for manually mapping colors to a vector of colors.
}
\details{
A helper function for manually mapping colors to a vector of colors. It is useful when you want to manually specify color data, 
rather than relying on ggplot functions.
}
\examples{
cliff_points <- clifford_attractor(1e4, 1.886,-2.357,-0.328, 0.918, 0.1, 0)
color_pal <- circular_palette(n=144, pal_function=rainbow)
cliff_points$color <- map_colors(color_pal, cliff_points$angle, min_limit=-pi, max_limit=pi)

gm <- GlowMapper4$new(xdim=240, ydim=240, blend_mode = "additive", nthreads=1)
gm$map(x=cliff_points$x, y=cliff_points$y, radius=0.1, color=cliff_points$color)
pd <- gm$output_dataframe(saturation = 1)

ggplot() +
  geom_raster(data = pd, aes(x = x, y = y, fill = rgb(r,g,b,a)), show.legend=FALSE) +
  coord_fixed(gm$aspect(), xlim = gm$xlim(), ylim = gm$ylim()) + 
  scale_fill_identity() + 
  theme_night()
}
