% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_data.R
\name{gls_example}
\alias{gls_example}
\title{Get Path to Example Data}
\usage{
gls_example(which = "all")
}
\arguments{
\item{which}{Character string specifying which example file:
\itemize{
  \item "W086" - See metadata for details
  \item "W592" - See metadata for details
  \item "synthetic" - See metadata for details
  \item "all" - Returns paths to all example files (default)
}}
}
\value{
Character vector of file path(s) to example data
}
\description{
Helper function to get the path to example .lux files included with the package.
Three example files are available and their metadata is exposed via
\code{glscalibrator_example_metadata}.
}
\examples{
# Inspect available example datasets
list_gls_examples()

# Read the bundled W086 seabird deployment
light_data <- read_lux_file(gls_example("W086"))

# Run calibration on the synthetic dataset (quick demo)
synt_path <- gls_example("synthetic")
synthetic_data <- read_lux_file(synt_path)
twl <- detect_twilights(synthetic_data, threshold = 2)

}
