% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-link.R
\name{md_link}
\alias{md_link}
\title{Markdown inline link (6.6)}
\usage{
md_link(text, url, title = NULL, ..., .name = FALSE)
}
\arguments{
\item{text}{A character vector of text with another vector of URLs passed to
the \code{url} argument.}

\item{url}{A character vector of URLs.}

\item{title}{The optional title of the link.}

\item{...}{A sequence of \code{text = "/url"} named vector pairs. If any such
pairs are provided, \code{.name} will be considered \code{TRUE}.}

\item{.name}{logical; if \code{TRUE}, the pairs in \code{...} will be used instead of
any values supplied to \code{x} and \code{url}.}
}
\value{
A \code{glue} vector of collapsed display text and associated URLs.
}
\description{
Take character vectors of link texts, link destinations, and optional titles
and return single glue vector of valid markdown inline links. This inline is
rendered as the \verb{<href>} HTML tag.
}
\details{
A link contains link text (the visible text), a link destination (the URI
that is the link destination), and optionally a link title. There are two
basic kinds of links in Markdown. In inline links the destination and title
are given immediately after the link text.

A link text consists of a sequence of zero or more inline elements enclosed
by square brackets (\code{[} and \verb{]})...

An inline link consists of a link text followed immediately by a left
parenthesis \code{(}, optional whitespace, an optional link destination, an
optional link title separated from the link destination by whitespace,
optional whitespace, and a right parenthesis \verb{)}. The link’s text consists of
the inlines contained in the link text (excluding the enclosing square
brackets). The link’s URI consists of the link destination, excluding
enclosing \verb{<...>} if present, with backslash-escapes in effect as described
above. The link’s title consists of the link title, excluding its enclosing
delimiters, with backslash-escapes in effect as described above.
}
\examples{
md_link(1:5, glue::glue("https://{state.abb[1:5]}.gov"), state.name[1:5])
md_link(CRAN = "https://cran.r-project.org/")
}
\seealso{
Other inline functions: 
\code{\link{md_autolink}()},
\code{\link{md_bold}()},
\code{\link{md_code}()},
\code{\link{md_convert}()},
\code{\link{md_disallow}()},
\code{\link{md_escape}()},
\code{\link{md_hardline}()},
\code{\link{md_image}()},
\code{\link{md_issue}()},
\code{\link{md_italic}()},
\code{\link{md_softline}()},
\code{\link{md_strike}()},
\code{\link{md_text}()}
}
\concept{inline functions}
