% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-line-.R
\name{Line}
\alias{Line}
\title{Create \code{Line} Object}
\usage{
Line(
  pitches = NULL,
  durations = NULL,
  tie = NULL,
  name = NULL,
  as = NULL,
  to = NULL,
  after = NULL,
  bar = NULL,
  offset = NULL
)
}
\arguments{
\item{pitches}{A list or vector which represents the pitches
of a musical line. The items of \code{pitches} can be
\itemize{
\item single characters like \code{"C4"}, which represent pitch notations,
\item single integers between 12 and 127, which represent MIDI note numbers,
\item single \code{NA}s, which represent rests, and
\item vectors of pitch notations and MIDI note numbers, which represent chords.
}

If not provided, the default value is \code{NA}. If \code{pitches} and \code{durations}
are not of the same length, the shorter one will be recycled.
\code{pitches} and \code{durations} can not both be empty.}

\item{durations}{A list or vector which represents the
durations of a musical line. The items of \code{durations} can be
\itemize{
\item single numbers, which represent note lengths, and
\item single characters like \code{"quarter"}, which represent duration notations.
}

If not provided, the default value is 1.}

\item{tie}{Deprecated. Was used to add ties to notes. Please use
\code{\link[=Tie]{Tie()}} instead.}

\item{name}{Optional. A single character which represents the name of
the musical line. When adding components to a musical line,
it can be referred to by its name.}

\item{as}{Optional. A single character which can be \code{"part"}, \code{"staff"},
\code{"voice"}, and \code{"segment"}. It specifies how the musical line appears in
the music score. The default value is \code{"part"}.}

\item{to}{Optional. A single character or integer, which represents the
name or row number of a reference musical line to which to add the
current musical line. By default, the musical line will be added at the
end of the score.}

\item{after}{Optional. A single logical which indicates whether to add the
musical line after or before the reference musical line. The default value
is \code{TRUE}.}

\item{bar}{Optional. A positive integer, which indicates the number of
the measure where to add the musical line. By default, the musical line
will be added at the first measure.}

\item{offset}{Optional. A non-negative number,
which indicates the position in a measure where to add the musical line.
The default value is \code{0}.}
}
\value{
A list of class \code{Line}.
}
\description{
Create a \code{Line} object to represent a musical line. In gm,
the musical line is the basic unit of music. It appears in different
forms, such as voices, staffs, and parts in music scores.
}
\examples{
# Create a musical line
line <- Line(c("C4", "D4", "E4"))
line

# Add it to a music
music <- Music() + Meter(4, 4) + line
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a musical line to a \code{Music} object.
}
