% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propagation.R
\name{propagation}
\alias{propagation}
\title{Propagate particles forward in time}
\usage{
propagation(
  part,
  gmgm,
  evid = NULL,
  col_seq = NULL,
  col_weight = "weight",
  n_times = 1,
  min_ess = 1
)
}
\arguments{
\item{part}{A data frame containing the particles propagated to time slice
\eqn{t}, as obtained from function \code{\link{particles}} or
\code{\link{propagation}}.}

\item{gmgm}{An object of class \code{gmbn} or \code{gmdbn}. For a
\code{gmdbn} object, the \code{gmbn} elements used for propagation are
selected according to the temporal depth of the particles, assuming that the
particles contain all the samples since the first time slice (this depth is
thus considered as the current time slice).}

\item{evid}{A data frame containing the evidence of time slices
\eqn{t + 1, \dots , t + k}. Its columns must explicitly be named after nodes
of \code{gmgm} and can contain missing values (columns with no value can be
removed). If \code{NULL} (the default), no evidence is taken into account.}

\item{col_seq}{A character vector containing the column names of \code{part}
and \code{evid} that describe the observation sequence. If \code{NULL} (the
default), all the particles and observations belong to a single sequence. In
\code{evid}, the observations of a same sequence must be ordered such that
the \eqn{k}th one is related to time slice \eqn{t + k} (note that the
sequences can have different lengths).}

\item{col_weight}{A character string corresponding to the column name of
\code{part} that describes the particle weight.}

\item{n_times}{A non-negative integer corresponding to the number of time
slices \eqn{k} over which the particles are propagated.}

\item{min_ess}{A numeric value in [0, 1] corresponding to the minimum ESS
(expressed as a proportion of the number of particles) under which the
renewal step is performed. If \code{1} (the default), this step is performed
at each time slice.}
}
\value{
A data frame (tibble) containing the particles supplemented with the
samples of time slices \eqn{t + 1, \dots , t + k}.
}
\description{
This function propagates particles forward in time. Assuming that the
particles have been propagated to a given time slice \eqn{t}, the aim is to
propagate them to a later time slice \eqn{t + k} according to the Gaussian
mixture graphical model and to the evidence collected over time. At first, a
renewal step is performed if the effective sample size (ESS) is below a given
threshold (Doucet and Johansen, 2009). This step consists in randomly
selecting new particles among the old ones proportionately to their current
weights. Upon receiving the data (the evidence) of \eqn{t + 1}, each particle
is used to generate samples for the unknown values. Its weight is then
updated to the likelihood for the observed values. The higher this
likelihood, the more likely the particle is selected at the next renewal step
for propagation to \eqn{t + 2}, and so on (Koller and Friedman, 2009).
}
\examples{
\donttest{
library(dplyr)
set.seed(0)
data(gmdbn_air, data_air)
evid <- data_air \%>\%
  group_by(DATE) \%>\%
  slice(1:3) \%>\%
  ungroup()
evid$NO2[sample.int(150, 30)] <- NA
evid$O3[sample.int(150, 30)] <- NA
evid$TEMP[sample.int(150, 30)] <- NA
evid$WIND[sample.int(150, 30)] <- NA
part <- particles(data.frame(DATE = unique(evid$DATE))) \%>\%
  propagation(gmdbn_air, evid, col_seq = "DATE", n_times = 3)}

}
\references{
Doucet, A. and Johansen, A. M. (2009). A Tutorial on Particle Filtering and
Smoothing: Fifteen years later. \emph{Handbook of nonlinear filtering},
12:656--704.

Koller, D. and Friedman, N. (2009). \emph{Probabilistic Graphical Models:
Principles and Techniques}. The MIT Press.
}
\seealso{
\code{\link{aggregation}}, \code{\link{particles}}
}
