% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relevant.R
\name{relevant}
\alias{relevant}
\title{Extract the minimal sub-Gaussian mixture graphical model required to infer a
subset of nodes}
\usage{
relevant(gmgm, nodes, nodes_obs = NULL, nodes_miss = NULL)
}
\arguments{
\item{gmgm}{An object of class \code{gmbn} or \code{gmdbn}.}

\item{nodes}{A character vector containing the inferred nodes.}

\item{nodes_obs}{A character vector containing the nodes whose values are
observed.}

\item{nodes_miss}{A character vector containing the nodes whose values are
missing. Note that if a node is neither in \code{nodes_obs} nor in
\code{nodes_miss}, its observability is considered uncertain or varying.
Thus, it is not treated as an observed node, nor can it be removed as a
barren node.}
}
\value{
The \code{gmbn} or \code{gmdbn} object relevant to the subset of
nodes.
}
\description{
This function extracts the minimal sub-Gaussian mixture graphical model
required to infer a subset of nodes (i.e. the sub-model relevant to these
nodes). The nodes that do not contribute to inference are removed, which
includes those that are d-separated from the inferred ones by the nodes whose
values are observed, as well as the barren nodes (Druzdzel and Suermondt,
1994).
}
\examples{
data(gmbn_body)
gmbn_1 <- relevant(gmbn_body, "AGE",
                   nodes_obs = c("FAT", "HEIGHT", "WEIGHT"),
                   nodes_miss = "GLYCO")

data(gmdbn_air)
gmdbn_1 <- do.call("gmdbn", gmdbn_air[c("b_1", "b_2")])
gmdbn_2 <- relevant(gmdbn_1, "O3", nodes_obs = "NO2")

}
\references{
Druzdzel, M. J. and Suermondt, H. J. (1994). Relevance in Probabilistic
Models: "Backyards" in a "Small World". \emph{In Working Notes of the AAAI
1994 Fall Symposium Series: Relevance}, pages 60--63, New Orleans, LA, USA.
}
\seealso{
\code{\link{add_arcs}}, \code{\link{add_nodes}},
\code{\link{remove_arcs}}, \code{\link{remove_nodes}},
\code{\link{rename_nodes}}
}
