% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{ABEV2}
\alias{ABEV2}
\title{The second Allison-Betsch-Ebner-Visagie test statistic}
\usage{
ABEV2(data, a = 10, meth = "MME")
}
\arguments{
\item{data}{a vector of positive numbers.}

\item{a}{positive tuning parameter.}

\item{meth}{method of estimation used. Possible values are \code{'MME'} for moment estimation and \code{'MLE'} for maximum likelihood estimation.}
}
\value{
value of the test statistic.
}
\description{
This function computes the second test statistic of the goodness-of-fit tests for the inverse Gaussian family due to Allison et al. (2022). Two different estimation procedures are implemented, namely the method of moment and the maximum likelihood method.
}
\details{
The numerically stable test statistic for the second Allison-Betsch-Ebner-Visagie test is defined as:
\deqn{ABEV2_{n,a} = \frac{1}{4n} \sum_{j,k=1}^{n} \left( \hat{\varphi}_n + \frac{3}{Y_{n,j}} - \frac{\hat{\varphi}_n}{Y_{n,j}^2} \right) \left( \hat{\varphi}_n + \frac{3}{Y_{n,k}} - \frac{\hat{\varphi}_n}{Y_{n,k}^2} \right) \tilde{h}_{1,a}(Y_{n,j}, Y_{n,k})}
\deqn{- 2 \left( \hat{\varphi}_n + \frac{3}{Y_{n,j}} - \frac{\hat{\varphi}_n}{Y_{n,j}^2} \right) \tilde{h}_{2,a}(Y_{n,j}, Y_{n,k})}
\deqn{- 2 \left( \hat{\varphi}_n + \frac{3}{Y_{n,k}} - \frac{\hat{\varphi}_n}{Y_{n,k}^2} \right) \tilde{h}_{2,a}(Y_{n,k}, Y_{n,j})}
\deqn{+ 4 \frac{\sqrt{\pi}}{a} \Phi \left( - \sqrt{2a} \max(Y_{n,j}, Y_{n,k}) \right),}
with \eqn{\hat{\varphi}_n = \frac{\hat{\lambda}_n}{\hat{\mu}_n}}, where \eqn{\hat{\mu}_n,\hat{\lambda}_n} are consistent estimators of \eqn{\mu, \lambda}, respectively, the parameters of the inverse Gaussian distribution. Furthermore \eqn{Y_{n,j} = \frac{X_j}{\hat{\mu}_n}}, \eqn{j = 1,...,n}, for \eqn{(X_j)_{j = 1,...,n}}, a sequence of  independent observations of a positive random variable \eqn{X}. 
The functions \eqn{\tilde{h}_{i,a}(s,t)}, \eqn{i = 1,2}, are defined in Allison et al. (2022), section 5.1, and \eqn{\Phi} denotes the distribution function of the standard normal distribution.
The null hypothesis is rejected for large values of the test statistic \eqn{ABEV2_{n,a}}.
}
\examples{
ABEV2(rmutil::rinvgauss(20,2,1),a=10,meth='MLE')

}
\references{
Allison, J.S., Betsch, S., Ebner, B., Visagie, I.J.H. (2022) "On Testing the Adequacy of the Inverse Gaussian Distribution". \href{https://www.mdpi.com/2227-7390/10/3/350}{LINK}
}
