% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IGtest.R
\name{test.BG}
\alias{test.BG}
\title{The Baringhaus-Gaigall goodness-of-fit test for the inverse Gaussian family}
\usage{
test.BG(data, B)
}
\arguments{
\item{data}{a vector of positive numbers.}

\item{B}{number of bootstrap iterations used to obtain p value.}
}
\value{
a list containing the value of the name of the test statistic, the used tuning parameter, the parameter estimation method, the value of the test statistic, the bootstrap p value, the values of the estimators, and the number of bootstrap iterations: \cr
\describe{
        \item{\code{$Test}}{the name of the used test statistic.}
        \item{\code{$T.value}}{the value of the test statistic.}
        \item{\code{$p.value}}{the approximated p value.}
        \item{\code{$par.est}}{the estimated parameters.}
        \item{\code{$boot.run}}{number of bootstrap iterations.}
}
}
\description{
This function computes the goodness-of-fit test for the inverse Gaussian family due to Baringhaus and Gaigall (2015).
}
\examples{
test.BG(rmutil::rinvgauss(20,2,1),B=100)

}
\references{
Baringhaus, L.  Gaigall, D. (2015). "On an independence test approach to the goodness-of-fit problem", Journal of Multivariate Analysis, 140, 193-208. \doi{https://doi.org/10.1016/j.jmva.2015.05.013}
}
