% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{ga_users_delete_linkid}
\alias{ga_users_delete_linkid}
\title{Delete users access from account, webproperty or view level}
\usage{
ga_users_delete_linkid(
  linkId,
  accountId,
  webPropertyId = NULL,
  viewId = NULL,
  check = TRUE
)
}
\arguments{
\item{linkId}{The linkId(s) that is available using \link{ga_users_list} e.g. \code{47480439:104185380183364788718}}

\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id - set to NULL to operate on account level only}

\item{viewId}{viewId - set to NULL to operate on webProperty level only}

\item{check}{If the default \code{TRUE} will check that the user has user access at the level you are trying to delete them from - if not will throw an error.}
}
\value{
TRUE if the deletion is successful, an error if not.
}
\description{
The \code{linkId} is in the form of the accountId/webPropertyId/viewId colon separated from a link unique Id.

Delete user access by supplying the linkId for that user at the level they have been given access.  It won't work to delete user links at account level if they have been assigned at web property or view level - you will need to get the linkId for that level instead. e.g. a user needs \code{permissions.local} to be non-NULL to be deleted at that level.  The parameter \code{check} will do this check before deletion and throw an error if they can not be deleted.   Set this to \code{check=FALSE} to suppress this behaviour.

If you supply more than one \code{linkId}, then batch processing will be applied.  Batching has special rules that give you 30 operations for the cost of one API call against your quota. When batching you will only get a \code{TRUE} result on successful batch, but individual \code{linkId}s may have failed.  Check via \link{ga_users_list} afterwards and try to delete individual linkIds to get more descriptive error messages.
}
\examples{

\dontrun{

library(googleAnalyticsR)
ga_auth()

# get the linkId for the user you want to delete
ga_users_list(47480439, webPropertyId = "UA-47480439-2", viewId = 81416156)
ga_users_delete_linkid("81416156:114834495587136933146", 
                       accountId = 47480439, 
                       webPropertyId = "UA-47480439-2", 
                       viewId = 81416156)

# check its gone
ga_users_list(47480439, webPropertyId = "UA-47480439-2", viewId = 81416156)

# can only delete at level user has access, the above deletion woud have failed if via:
ga_users_delete_linkid("47480439:114834495587136933146", 47480439)

}
}
\seealso{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/accountUserLinks/delete}{Google Documentation}

Other User management functions: 
\code{\link{ga_users_add}()},
\code{\link{ga_users_delete}()},
\code{\link{ga_users_list}()},
\code{\link{ga_users_update}()}
}
\concept{User management functions}
