% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{gcs_compose_objects}
\alias{gcs_compose_objects}
\title{Compose up to 32 objects into one}
\usage{
gcs_compose_objects(objects, destination, bucket = gcs_get_global_bucket())
}
\arguments{
\item{objects}{A character vector of object names to combine}

\item{destination}{Name of the new object.}

\item{bucket}{The bucket where the objects sit}
}
\value{
Object metadata
}
\description{
This merges objects stored on Cloud Storage into one object.
}
\examples{

\dontrun{
 gcs_global_bucket("your-bucket")
 objs <- gcs_list_objects()
 
 compose_me <- objs$name[1:30]
 
 gcs_compose_objects(compose_me, "composed/test.json")

}
}
\seealso{
\href{https://cloud.google.com/storage/docs/json_api/v1/objects/compose}{Compose objects}

Other object functions: 
\code{\link{gcs_copy_object}()},
\code{\link{gcs_delete_object}()},
\code{\link{gcs_get_object}()},
\code{\link{gcs_list_objects}()},
\code{\link{gcs_metadata_object}()}
}
\concept{object functions}
