% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_error_message.R
\name{format_error_message}
\alias{format_error_message}
\title{Format Error Message for Google Error Reporting}
\usage{
format_error_message(
  message = "Error description",
  service = "My Service",
  version = "0.0.1",
  method = "GET",
  url = "https://example.com",
  user_agent = "",
  referrer = "",
  response_status_code = "500",
  remote_ip = "192.178.0.0.1",
  user_id = "UserID",
  filepath = "/",
  line_number = 0,
  function_name = "my_function"
)
}
\arguments{
\item{message}{the error message you want in the logs}

\item{service}{the name of your service}

\item{version}{the version of the service}

\item{method}{the http method used for hte call}

\item{url}{hte unique resource identifier that was called}

\item{user_agent}{the user agente identifier}

\item{referrer}{the referrer to the service}

\item{response_status_code}{http response code}

\item{remote_ip}{remote ip}

\item{user_id}{user id}

\item{filepath}{filepath of the code where the error originates}

\item{line_number}{line number where the error originates}

\item{function_name}{function name where the error originates}
}
\value{
message object, a list to be formated as JSON in the error report body
}
\description{
Format Error Message for Google Error Reporting
}
\examples{
\dontrun{
message <- format_error_message()

message$serviceContext$service <- "A demo service"
message$serviceContext$version <- "v0.3.4"
}
}
